/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.spring;

import javax.servlet.ServletContext;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.plugins.spring.SpringBeanProcessor;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.ContextLoader;

public class SpringContextLoader
extends ContextLoader {
    protected void customizeContext(ServletContext servletContext, ConfigurableWebApplicationContext configurableWebApplicationContext) {
        super.customizeContext(servletContext, configurableWebApplicationContext);
        ResteasyProviderFactory providerFactory = (ResteasyProviderFactory)servletContext.getAttribute(ResteasyProviderFactory.class.getName());
        if (providerFactory == null) {
            throw new RuntimeException("RESTeasy Provider Factory is null, do you have the ResteasyBootstrap listener configured?");
        }
        Registry registry = (Registry)servletContext.getAttribute(Registry.class.getName());
        if (registry == null) {
            throw new RuntimeException("RESTeasy Registry is null, do ou have the ResteasyBootstrap listener configured?");
        }
        Dispatcher dispatcher = (Dispatcher)servletContext.getAttribute(Dispatcher.class.getName());
        if (registry == null) {
            throw new RuntimeException("RESTeasy Dispatcher is null, do ou have the ResteasyBootstrap listener configured?");
        }
        configurableWebApplicationContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new SpringBeanProcessor(dispatcher, registry, providerFactory));
    }
}

