/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.springmvc;

import java.io.IOException;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.jboss.resteasy.core.DispatcherUtilities;
import org.jboss.resteasy.core.ResourceInvoker;
import org.jboss.resteasy.core.ResourceLocator;
import org.jboss.resteasy.core.ResourceMethod;
import org.jboss.resteasy.core.ResponseInvoker;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.server.servlet.HttpServletResponseWrapper;
import org.jboss.resteasy.plugins.server.servlet.ServletSecurityContext;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.LoggableFailure;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.springmvc.ResteasyRequestWrapper;
import org.jboss.resteasy.springmvc.ResteasyView;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public class ResteasyHandlerAdapter
implements HandlerAdapter {
    private SynchronousDispatcher dispatcher;

    public ResteasyHandlerAdapter(SynchronousDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public long getLastModified(HttpServletRequest request, Object handler) {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAndView handle(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Object handler) throws Exception {
        ResteasyRequestWrapper responseWrapper = (ResteasyRequestWrapper)handler;
        HttpServletResponseWrapper response = new HttpServletResponseWrapper(servletResponse, this.dispatcher.getProviderFactory());
        try {
            ResteasyProviderFactory.pushContext(HttpServletRequest.class, (Object)servletRequest);
            ResteasyProviderFactory.pushContext(HttpServletResponse.class, (Object)servletResponse);
            ResteasyProviderFactory.pushContext(SecurityContext.class, (Object)new ServletSecurityContext(servletRequest));
            HttpRequest request = responseWrapper.getHttpRequest();
            this.dispatcher.getDispatcherUtilities().pushContextObjects(request, (HttpResponse)response);
            Response jaxrsResponse = null;
            try {
                ResourceInvoker invoker = responseWrapper.getInvoker();
                if (invoker instanceof ResourceMethod) {
                    ReflectionUtils.makeAccessible((Method)((ResourceMethod)invoker).getMethod());
                } else if (invoker instanceof ResourceLocator) {
                    ReflectionUtils.makeAccessible((Method)((ResourceLocator)invoker).getMethod());
                }
                jaxrsResponse = invoker.invoke(request, (HttpResponse)response);
            }
            catch (Exception e) {
                this.dispatcher.handleInvokerException(request, (HttpResponse)response, e);
            }
            try {
                if (jaxrsResponse != null) {
                    ModelAndView e = this.createModelAndView((HttpResponse)response, jaxrsResponse);
                    return e;
                }
            }
            catch (Exception e) {
                this.dispatcher.handleWriteResponseException(request, (HttpResponse)response, e);
            }
        }
        finally {
            ResteasyProviderFactory.clearContextData();
        }
        return null;
    }

    public ModelAndView createModelAndView(HttpResponse response, Response jaxrsResponse) throws IOException, WebApplicationException {
        DispatcherUtilities dispatcherUtilities = this.dispatcher.getDispatcherUtilities();
        dispatcherUtilities.writeCookies(response, jaxrsResponse);
        if (jaxrsResponse.getEntity() == null) {
            response.setStatus(jaxrsResponse.getStatus());
            dispatcherUtilities.outputHeaders(response, jaxrsResponse);
            return null;
        }
        dispatcherUtilities.writeCookies(response, jaxrsResponse);
        ResponseInvoker responseInvoker = new ResponseInvoker(dispatcherUtilities, jaxrsResponse);
        if (!(responseInvoker.getEntity() instanceof ModelAndView) && responseInvoker.getWriter() == null) {
            throw new LoggableFailure(String.format("Could not find MessageBodyWriter for response object of type: %s of media type: %s", responseInvoker.getType().getName(), responseInvoker.getContentType()), 500);
        }
        response.setStatus(jaxrsResponse.getStatus());
        dispatcherUtilities.outputHeaders(response, jaxrsResponse);
        String contentLength = String.valueOf(responseInvoker.getResponseSize());
        response.getOutputHeaders().putSingle((Object)"Content-Length", (Object)contentLength);
        if (responseInvoker.getEntity() instanceof ModelAndView) {
            return (ModelAndView)responseInvoker.getEntity();
        }
        return this.createModelAndView(responseInvoker);
    }

    protected ModelAndView createModelAndView(ResponseInvoker responseInvoker) {
        return new ModelAndView((View)this.createView(responseInvoker)).addObject((Object)responseInvoker);
    }

    protected ResteasyView createView(ResponseInvoker responseInvoker) {
        String contentType = responseInvoker.getContentType().toString();
        return new ResteasyView(contentType, this.dispatcher);
    }

    public boolean supports(Object handler) {
        return handler instanceof ResteasyRequestWrapper;
    }
}

