/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.springmvc;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.jboss.resteasy.core.ResponseInvoker;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.server.servlet.HttpServletResponseWrapper;
import org.jboss.resteasy.plugins.server.servlet.ServletSecurityContext;
import org.jboss.resteasy.specimpl.ResponseImpl;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.LoggableFailure;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.springmvc.RequestUtil;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResteasyView
implements View {
    private String contentType = null;
    private List<String> potentialContentTypes = null;
    private SynchronousDispatcher dispatcher;

    public ResteasyView(String contentType, SynchronousDispatcher dispatcher) {
        this.setContentType(contentType);
        this.setDispatcher(dispatcher);
    }

    public ResteasyView() {
    }

    public SynchronousDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(SynchronousDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public String getContentType() {
        return this.contentType;
    }

    public List<String> getPotentialContentTypes() {
        return this.potentialContentTypes;
    }

    public void setPotentialContentTypes(List<String> potentialContentTypes) {
        this.potentialContentTypes = potentialContentTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Map model, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        HttpRequest request = RequestUtil.getHttpRequest(servletRequest);
        HttpServletResponseWrapper response = new HttpServletResponseWrapper(servletResponse, this.dispatcher.getProviderFactory());
        try {
            ResteasyProviderFactory.pushContext(HttpServletRequest.class, (Object)servletRequest);
            ResteasyProviderFactory.pushContext(HttpServletResponse.class, (Object)servletResponse);
            ResteasyProviderFactory.pushContext(SecurityContext.class, (Object)new ServletSecurityContext(servletRequest));
            this.dispatcher.getDispatcherUtilities().pushContextObjects(request, (HttpResponse)response);
            this.writeResponse(request, (HttpResponse)response, this.getResponse(model));
        }
        catch (Exception e) {
            this.dispatcher.handleWriteResponseException(request, (HttpResponse)response, e);
        }
        finally {
            ResteasyProviderFactory.clearContextData();
        }
    }

    private void writeResponse(HttpRequest jaxrsRequest, HttpResponse response, ResponseInvoker responseInvoker) throws IOException {
        if (responseInvoker == null) {
            return;
        }
        MediaType unresolvedType = responseInvoker.getContentType();
        responseInvoker.setContentType(this.resolveContentType(jaxrsRequest, unresolvedType));
        if (responseInvoker.getWriter() == null) {
            String message = "Could not find MessageBodyWriter for response object of type: %s of media type: %s";
            throw new LoggableFailure(String.format(message, responseInvoker.getType().getName(), unresolvedType), 500);
        }
        responseInvoker.writeTo(response);
    }

    private MediaType resolveContentType(HttpRequest jaxrsRequest, MediaType mt) {
        if ("*".equals(mt.getType()) && !CollectionUtils.isEmpty(this.potentialContentTypes)) {
            List acceptableMediaTypes = jaxrsRequest.getHttpHeaders().getAcceptableMediaTypes();
            for (String potentialContentTypesStr : this.potentialContentTypes) {
                MediaType potentialContentType = MediaType.valueOf((String)potentialContentTypesStr);
                for (MediaType acceptableMediaType : acceptableMediaTypes) {
                    if (!acceptableMediaType.isCompatible(potentialContentType)) continue;
                    return potentialContentType;
                }
            }
        }
        return mt;
    }

    protected ResponseInvoker getResponse(Map model) {
        for (Object value : model.values()) {
            if (!(value instanceof ResponseInvoker)) continue;
            return (ResponseInvoker)value;
        }
        if (model.size() == 1) {
            ResponseImpl responseImpl = new ResponseImpl();
            responseImpl.setEntity(model.values().iterator().next());
            return new ResponseInvoker(this.dispatcher.getDispatcherUtilities(), (Response)responseImpl);
        }
        return null;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }
}

