/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.spring;

import java.net.URI;
import org.apache.commons.httpclient.HttpClient;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ProxyFactory;
import org.jboss.resteasy.client.core.executors.ApacheHttpClientExecutor;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestClientProxyFactoryBean<T>
implements FactoryBean,
InitializingBean {
    private Class<T> serviceInterface;
    private URI baseUri;
    private T client;
    private HttpClient httpClient;
    private ClientExecutor clientExecutor;
    private ResteasyProviderFactory resteasyProviderFactory;

    public T getObject() throws Exception {
        return this.client;
    }

    public Class<T> getObjectType() {
        return this.serviceInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.resteasyProviderFactory == null) {
            this.resteasyProviderFactory = ResteasyProviderFactory.getInstance();
        }
        RegisterBuiltin.register((ResteasyProviderFactory)this.resteasyProviderFactory);
        if (this.clientExecutor == null) {
            if (this.httpClient == null) {
                this.httpClient = new HttpClient();
            }
            this.clientExecutor = new ApacheHttpClientExecutor(this.httpClient);
            this.client = ProxyFactory.create(this.serviceInterface, (URI)this.baseUri, (ClientExecutor)this.clientExecutor, (ResteasyProviderFactory)this.resteasyProviderFactory);
        } else {
            this.client = ProxyFactory.create(this.serviceInterface, (URI)this.baseUri, (ClientExecutor)this.clientExecutor, (ResteasyProviderFactory)this.resteasyProviderFactory);
        }
    }

    public Class<T> getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(Class<T> serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public void setBaseUri(URI baseUri) {
        this.baseUri = baseUri;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public ClientExecutor getClientExecutor() {
        return this.clientExecutor;
    }

    public void setClientExecutor(ClientExecutor clientExecutor) {
        this.clientExecutor = clientExecutor;
    }

    public ResteasyProviderFactory getResteasyProviderFactory() {
        return this.resteasyProviderFactory;
    }

    public void setResteasyProviderFactory(ResteasyProviderFactory resteasyProviderFactory) {
        this.resteasyProviderFactory = resteasyProviderFactory;
    }
}

