/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.springmvc;

import org.mortbay.jetty.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class JettyLifecycleManager
implements InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(JettyLifecycleManager.class);
    private Server servletContainer;

    public Server getServletContainer() {
        return this.servletContainer;
    }

    public void setServletContainer(Server servletContainer) {
        this.servletContainer = servletContainer;
    }

    public void afterPropertiesSet() throws Exception {
        logger.info("Starting up Jetty");
        try {
            this.servletContainer.start();
            while (!this.servletContainer.isStarted()) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            logger.error("Interrupted while starting up Jetty", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Exception while starting up Jetty", (Throwable)e);
        }
    }

    public void destroy() throws Exception {
        logger.info("Shutting down Jetty");
        try {
            this.servletContainer.stop();
        }
        catch (Exception e) {
            logger.info("Exception while shutting down Jetty", (Throwable)e);
        }
    }
}

