/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.validation;

import java.lang.reflect.Method;
import java.util.Iterator;
import javax.validation.ConstraintViolation;
import javax.validation.ElementKind;
import javax.validation.Path;
import org.jboss.resteasy.plugins.providers.validation.ConstraintTypeUtil;
import org.jboss.resteasy.spi.validation.ConstraintType;

public class ConstraintTypeUtil11
implements ConstraintTypeUtil {
    public ConstraintType.Type getConstraintType(Object o) {
        if (!(o instanceof ConstraintViolation)) {
            throw new RuntimeException("unknown object passed as constraint violation: " + o);
        }
        ConstraintViolation v = (ConstraintViolation)ConstraintViolation.class.cast(o);
        Iterator nodes = v.getPropertyPath().iterator();
        Path.Node firstNode = (Path.Node)nodes.next();
        if (firstNode.getKind() == ElementKind.METHOD) {
            Path.Node secondNode = (Path.Node)nodes.next();
            if (secondNode.getKind() == ElementKind.PARAMETER || secondNode.getKind() == ElementKind.CROSS_PARAMETER) {
                return ConstraintType.Type.PARAMETER;
            }
            if (secondNode.getKind() == ElementKind.RETURN_VALUE) {
                return ConstraintType.Type.RETURN_VALUE;
            }
            throw new RuntimeException("unexpected path node type in method violation: " + secondNode.getKind());
        }
        if (firstNode.getKind() == ElementKind.BEAN) {
            return ConstraintType.Type.CLASS;
        }
        if (firstNode.getKind() == ElementKind.PROPERTY) {
            String fieldName = this.getLeafNode(v).getName();
            try {
                String getterName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                ConstraintTypeUtil11.getMethod(v.getLeafBean().getClass(), getterName);
                return ConstraintType.Type.PROPERTY;
            }
            catch (NoSuchMethodException e) {
                return ConstraintType.Type.FIELD;
            }
        }
        throw new RuntimeException("unexpeced path node type: " + firstNode.getKind());
    }

    private static Method getMethod(Class<?> clazz, String methodName) throws NoSuchMethodException {
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        while (method == null && (clazz = clazz.getSuperclass()) != null) {
            try {
                method = clazz.getDeclaredMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        if (method == null) {
            throw new NoSuchMethodException(methodName);
        }
        return method;
    }

    private Path.Node getLeafNode(ConstraintViolation violation) {
        Iterator nodes = violation.getPropertyPath().iterator();
        Path.Node leafNode = null;
        while (nodes.hasNext()) {
            leafNode = (Path.Node)nodes.next();
        }
        return leafNode;
    }
}

