/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.validation;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.executable.ExecutableType;
import javax.validation.executable.ValidateOnExecution;
import javax.validation.metadata.BeanDescriptor;
import org.jboss.resteasy.plugins.providers.validation.ConstraintTypeUtil;
import org.jboss.resteasy.plugins.providers.validation.GeneralValidator;
import org.jboss.resteasy.plugins.validation.ConstraintTypeUtil11;
import org.jboss.resteasy.spi.validation.ConstraintType;
import org.jboss.resteasy.spi.validation.ResteasyConstraintViolation;

public class GeneralValidatorImpl
implements GeneralValidator {
    private static final Set<ResteasyConstraintViolation> empty = new HashSet<ResteasyConstraintViolation>();
    private Validator validator;
    private ConstraintTypeUtil util = new ConstraintTypeUtil11();

    public GeneralValidatorImpl(Validator validator) {
        this.validator = validator;
    }

    public <T> Set<ResteasyConstraintViolation> validate(T object, Class<?> ... groups) {
        Set cvs = this.validator.validate(object, (Class[])groups);
        HashSet<ResteasyConstraintViolation> rcvs = new HashSet<ResteasyConstraintViolation>();
        for (ConstraintViolation cv : cvs) {
            ConstraintType.Type ct = this.util.getConstraintType((Object)cv);
            rcvs.add(new ResteasyConstraintViolation(ct, cv.getPropertyPath().toString(), cv.getMessage(), cv.getInvalidValue().toString()));
        }
        return rcvs;
    }

    public <T> Set<ResteasyConstraintViolation> validateProperty(T object, String propertyName, Class<?> ... groups) {
        Set cvs = this.validator.validateProperty(object, propertyName, (Class[])groups);
        HashSet<ResteasyConstraintViolation> rcvs = new HashSet<ResteasyConstraintViolation>();
        for (ConstraintViolation cv : cvs) {
            ConstraintType.Type ct = this.util.getConstraintType((Object)cv);
            rcvs.add(new ResteasyConstraintViolation(ct, cv.getPropertyPath().toString(), cv.getMessage(), cv.getInvalidValue().toString()));
        }
        return rcvs;
    }

    public <T> Set<ResteasyConstraintViolation> validateValue(Class<T> beanType, String propertyName, Object value, Class<?> ... groups) {
        Set cvs = this.validator.validateValue(beanType, propertyName, value, (Class[])groups);
        HashSet<ResteasyConstraintViolation> rcvs = new HashSet<ResteasyConstraintViolation>();
        for (ConstraintViolation cv : cvs) {
            ConstraintType.Type ct = this.util.getConstraintType((Object)cv);
            rcvs.add(new ResteasyConstraintViolation(ct, cv.getPropertyPath().toString(), cv.getMessage(), cv.getInvalidValue().toString()));
        }
        return rcvs;
    }

    public BeanDescriptor getConstraintsForClass(Class<?> clazz) {
        return this.validator.getConstraintsForClass(clazz);
    }

    public <T> T unwrap(Class<T> type) {
        return (T)this.validator.unwrap(type);
    }

    public <T> Set<ResteasyConstraintViolation> validateParameter(T object, Method method, Object parameterValue, int parameterIndex, Class<?> ... groups) {
        HashSet<ResteasyConstraintViolation> rcvs = new HashSet<ResteasyConstraintViolation>();
        return rcvs;
    }

    public <T> Set<ResteasyConstraintViolation> validateAllParameters(T object, Method method, Object[] parameterValues, Class<?> ... groups) {
        if (method.getParameterTypes().length == 0) {
            return empty;
        }
        Set cvs = this.validator.forExecutables().validateParameters(object, method, parameterValues, (Class[])groups);
        HashSet<ResteasyConstraintViolation> rcvs = new HashSet<ResteasyConstraintViolation>();
        for (ConstraintViolation cv : cvs) {
            ConstraintType.Type ct = this.util.getConstraintType((Object)cv);
            rcvs.add(new ResteasyConstraintViolation(ct, cv.getPropertyPath().toString(), cv.getMessage(), cv.getInvalidValue().toString()));
        }
        return rcvs;
    }

    public <T> Set<ResteasyConstraintViolation> validateReturnValue(T object, Method method, Object returnValue, Class<?> ... groups) {
        Set cvs = this.validator.forExecutables().validateReturnValue(object, method, returnValue, (Class[])groups);
        HashSet<ResteasyConstraintViolation> rcvs = new HashSet<ResteasyConstraintViolation>();
        for (ConstraintViolation cv : cvs) {
            ConstraintType.Type ct = this.util.getConstraintType((Object)cv);
            rcvs.add(new ResteasyConstraintViolation(ct, cv.getPropertyPath().toString(), cv.getMessage(), cv.getInvalidValue().toString()));
        }
        return rcvs;
    }

    public boolean isValidatable(Class<?> clazz) {
        return true;
    }

    public boolean isMethodValidatable(Method m) {
        ExecutableType[] types = null;
        ValidateOnExecution voe = m.getAnnotation(ValidateOnExecution.class);
        if (voe == null || voe.type().length == 0) {
            types = GeneralValidatorImpl.getSuperMethodExecutableTypes(m);
            if (types == null) {
                types = GeneralValidatorImpl.getClassExecutableTypes(m);
            }
        } else {
            types = voe.type();
        }
        if (types == null || types.length == 0) {
            return true;
        }
        boolean isGetterMethod = GeneralValidatorImpl.isGetter(m);
        block6: for (int i = 0; i < types.length; ++i) {
            switch (types[i]) {
                case IMPLICIT: 
                case ALL: {
                    return true;
                }
                case NONE: {
                    continue block6;
                }
                case NON_GETTER_METHODS: {
                    if (isGetterMethod) continue block6;
                    return true;
                }
                case GETTER_METHODS: {
                    if (!isGetterMethod) continue block6;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ExecutableType[] getSuperMethodExecutableTypes(Method m) {
        Class<?> c = m.getDeclaringClass().getSuperclass();
        ExecutableType[] executableTypes = null;
        while (c != null) {
            try {
                ExecutableType[] types;
                ValidateOnExecution voe;
                Method superMethod = c.getDeclaredMethod(m.getName(), m.getParameterTypes());
                if (superMethod == null || (voe = superMethod.getAnnotation(ValidateOnExecution.class)) == null || voe.type().length == 0 || (types = voe.type()) == null || types.length == 0) continue;
                executableTypes = types;
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            continue;
            finally {
                c = c.getSuperclass();
            }
        }
        return executableTypes;
    }

    protected static ExecutableType[] getClassExecutableTypes(Method m) {
        ValidateOnExecution voe = m.getDeclaringClass().getAnnotation(ValidateOnExecution.class);
        if (voe == null) {
            return null;
        }
        ExecutableType[] types = voe.type();
        if (types == null || types.length == 0) {
            return null;
        }
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equals((Object)ExecutableType.IMPLICIT)) continue;
            return null;
        }
        return types;
    }

    protected static boolean isGetter(Method m) {
        String name = m.getName();
        Class<?> returnType = m.getReturnType();
        if (returnType.equals(Void.class)) {
            return false;
        }
        if (m.getParameterTypes().length > 0) {
            return false;
        }
        if (name.startsWith("get")) {
            return true;
        }
        return name.startsWith("is") && returnType.equals(Boolean.class);
    }
}

