/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.api.validation;

import javax.validation.ConstraintDeclarationException;
import javax.validation.ConstraintDefinitionException;
import javax.validation.GroupDefinitionException;
import javax.validation.ValidationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.api.validation.ResteasyViolationException;

@Provider
public class ResteasyViolationExceptionMapper
implements ExceptionMapper<ValidationException> {
    public Response toResponse(ValidationException exception) {
        if (exception instanceof ConstraintDefinitionException) {
            return this.buildResponse(this.unwrapException((Throwable)exception), "text/plain", Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (exception instanceof ConstraintDeclarationException) {
            return this.buildResponse(this.unwrapException((Throwable)exception), "text/plain", Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (exception instanceof GroupDefinitionException) {
            return this.buildResponse(this.unwrapException((Throwable)exception), "text/plain", Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (exception instanceof ResteasyViolationException) {
            ResteasyViolationException resteasyViolationException = (ResteasyViolationException)((Object)ResteasyViolationException.class.cast(exception));
            Exception e = resteasyViolationException.getException();
            if (e != null) {
                return this.buildResponse(this.unwrapException(e), "text/plain", Response.Status.INTERNAL_SERVER_ERROR);
            }
            if (resteasyViolationException.getReturnValueViolations().size() == 0) {
                return this.buildResponse(resteasyViolationException.toString(), "text/plain", Response.Status.BAD_REQUEST);
            }
            return this.buildResponse(resteasyViolationException.toString(), "text/plain", Response.Status.INTERNAL_SERVER_ERROR);
        }
        return this.buildResponse(this.unwrapException((Throwable)exception), "text/plain", Response.Status.INTERNAL_SERVER_ERROR);
    }

    protected Response buildResponse(Object entity, String mediaType, Response.Status status) {
        Response.ResponseBuilder builder = Response.status((Response.Status)status).entity(entity);
        builder.type("text/plain");
        builder.header("validation-exception", (Object)"true");
        return builder.build();
    }

    protected String unwrapException(Throwable t) {
        StringBuffer sb = new StringBuffer();
        this.doUnwrapException(sb, t);
        return sb.toString();
    }

    private void doUnwrapException(StringBuffer sb, Throwable t) {
        if (t == null) {
            return;
        }
        sb.append(t.toString());
        if (t.getCause() != null && t != t.getCause()) {
            sb.append('[');
            this.doUnwrapException(sb, t.getCause());
            sb.append(']');
        }
    }
}

