/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.validation;

import jakarta.validation.ConstraintDeclarationException;
import jakarta.validation.ConstraintDefinitionException;
import jakarta.validation.GroupDefinitionException;
import jakarta.validation.ValidationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.util.List;
import org.jboss.resteasy.api.validation.ResteasyViolationException;
import org.jboss.resteasy.api.validation.ViolationReport;

@Provider
public class ResteasyViolationExceptionMapper
implements ExceptionMapper<ValidationException> {
    public Response toResponse(ValidationException exception) {
        if (exception instanceof ConstraintDefinitionException) {
            return this.buildResponse(this.unwrapException((Throwable)exception), "text/plain", Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (exception instanceof ConstraintDeclarationException) {
            return this.buildResponse(this.unwrapException((Throwable)exception), "text/plain", Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (exception instanceof GroupDefinitionException) {
            return this.buildResponse(this.unwrapException((Throwable)exception), "text/plain", Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (exception instanceof ResteasyViolationException) {
            ResteasyViolationException resteasyViolationException = (ResteasyViolationException)ResteasyViolationException.class.cast(exception);
            Exception e = resteasyViolationException.getException();
            if (e != null) {
                return this.buildResponse(this.unwrapException(e), "text/plain", Response.Status.INTERNAL_SERVER_ERROR);
            }
            if (resteasyViolationException.getReturnValueViolations().size() == 0) {
                return this.buildViolationReportResponse(resteasyViolationException, Response.Status.BAD_REQUEST);
            }
            return this.buildViolationReportResponse(resteasyViolationException, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return this.buildResponse(this.unwrapException((Throwable)exception), "text/plain", Response.Status.INTERNAL_SERVER_ERROR);
    }

    protected Response buildResponse(Object entity, String mediaType, Response.Status status) {
        Response.ResponseBuilder builder = Response.status((Response.Status)status).entity(entity);
        builder.type("text/plain");
        builder.header("validation-exception", (Object)"true");
        return builder.build();
    }

    protected Response buildViolationReportResponse(ResteasyViolationException exception, Response.Status status) {
        Response.ResponseBuilder builder = Response.status((Response.Status)status);
        builder.header("validation-exception", (Object)"true");
        MediaType mediaType = this.getAcceptMediaType(exception.getAccept());
        if (mediaType != null) {
            builder.type(mediaType);
            builder.entity((Object)new ViolationReport(exception));
            return builder.build();
        }
        builder.type("text/plain");
        builder.entity((Object)exception.toString());
        return builder.build();
    }

    protected String unwrapException(Throwable t) {
        StringBuffer sb = new StringBuffer();
        this.doUnwrapException(sb, t);
        return sb.toString();
    }

    private void doUnwrapException(StringBuffer sb, Throwable t) {
        if (t == null) {
            return;
        }
        sb.append(t.toString());
        if (t.getCause() != null && t != t.getCause()) {
            sb.append('[');
            this.doUnwrapException(sb, t.getCause());
            sb.append(']');
        }
    }

    private MediaType getAcceptMediaType(List<MediaType> accept) {
        for (MediaType mt : accept) {
            if (MediaType.APPLICATION_XML_TYPE.getType().equals(mt.getType()) && MediaType.APPLICATION_XML_TYPE.getSubtype().equals(mt.getSubtype())) {
                return MediaType.APPLICATION_XML_TYPE;
            }
            if (!MediaType.APPLICATION_JSON_TYPE.getType().equals(mt.getType()) || !MediaType.APPLICATION_JSON_TYPE.getSubtype().equals(mt.getSubtype())) continue;
            return MediaType.APPLICATION_JSON_TYPE;
        }
        return null;
    }
}

