/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.validation;

import jakarta.validation.BootstrapConfiguration;
import jakarta.validation.Configuration;
import jakarta.validation.Validation;
import jakarta.validation.ValidationException;
import jakarta.validation.ValidatorFactory;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.resteasy.plugins.validation.GeneralValidatorImpl;
import org.jboss.resteasy.plugins.validation.i18n.LogMessages;
import org.jboss.resteasy.plugins.validation.i18n.Messages;
import org.jboss.resteasy.spi.validation.GeneralValidatorCDI;

public class AbstractValidatorContextResolver {
    private volatile ValidatorFactory validatorFactory;
    static final Object RD_LOCK = new Object();
    private volatile Configuration<?> config;
    private volatile BootstrapConfiguration bootstrapConfiguration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ValidatorFactory getValidatorFactory() {
        ValidatorFactory tmpValidatorFactory = this.validatorFactory;
        if (tmpValidatorFactory == null) {
            Object object = RD_LOCK;
            synchronized (object) {
                tmpValidatorFactory = this.validatorFactory;
                if (tmpValidatorFactory == null) {
                    try {
                        InitialContext context = new InitialContext();
                        this.validatorFactory = tmpValidatorFactory = (ValidatorFactory)ValidatorFactory.class.cast(context.lookup("java:comp/ValidatorFactory"));
                        LogMessages.LOGGER.debug(Messages.MESSAGES.usingValidatorFactorySupportsCDI(this.validatorFactory));
                    }
                    catch (NamingException e) {
                        LogMessages.LOGGER.info(Messages.MESSAGES.usingValidatorFactoryDoesNotSupportCDI());
                        Configuration config = Validation.byDefaultProvider().configure();
                        this.validatorFactory = tmpValidatorFactory = config.buildValidatorFactory();
                    }
                }
            }
        }
        return tmpValidatorFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BootstrapConfiguration getConfig() {
        BootstrapConfiguration tmpConfig = this.bootstrapConfiguration;
        if (tmpConfig == null) {
            Object object = RD_LOCK;
            synchronized (object) {
                tmpConfig = this.bootstrapConfiguration;
                if (tmpConfig == null) {
                    this.config = Validation.byDefaultProvider().configure();
                    this.bootstrapConfiguration = tmpConfig = this.config.getBootstrapConfiguration();
                }
            }
        }
        return tmpConfig;
    }

    public GeneralValidatorCDI getContext(Class<?> type) {
        try {
            BootstrapConfiguration bootstrapConfiguration = this.getConfig();
            boolean isExecutableValidationEnabled = bootstrapConfiguration.isExecutableValidationEnabled();
            Set defaultValidatedExecutableTypes = bootstrapConfiguration.getDefaultValidatedExecutableTypes();
            return new GeneralValidatorImpl(this.getValidatorFactory(), isExecutableValidationEnabled, defaultValidatedExecutableTypes);
        }
        catch (Exception e) {
            throw new ValidationException(Messages.MESSAGES.unableToLoadValidationSupport(), (Throwable)e);
        }
    }
}

