/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.vertx;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class VertxResourceFactory
implements ResourceFactory {
    private final ResourceFactory delegate;
    private final String id = UUID.randomUUID().toString();

    public VertxResourceFactory(ResourceFactory delegate) {
        this.delegate = delegate;
    }

    public Class<?> getScannableClass() {
        return this.delegate.getScannableClass();
    }

    public void registered(ResteasyProviderFactory factory) {
        this.delegate.registered(factory);
    }

    public CompletionStage<Object> createResource(HttpRequest request, HttpResponse response, ResteasyProviderFactory factory) {
        Context ctx = Vertx.currentContext();
        if (ctx != null) {
            Object resource = ctx.get(this.id);
            if (resource == null) {
                return this.delegate.createResource(request, response, factory).thenApply(newResource -> {
                    ctx.put(this.id, newResource);
                    return newResource;
                });
            }
            return CompletableFuture.completedFuture(resource);
        }
        throw new IllegalStateException();
    }

    public void requestFinished(HttpRequest request, HttpResponse response, Object resource) {
        this.delegate.requestFinished(request, response, resource);
    }

    public void unregistered() {
        this.delegate.unregistered();
    }
}

