/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.vertx;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import jakarta.ws.rs.core.SecurityContext;
import java.io.IOException;
import java.security.Principal;
import java.util.Base64;
import java.util.List;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.core.ThreadLocalResteasyProviderFactory;
import org.jboss.resteasy.plugins.server.embedded.SecurityDomain;
import org.jboss.resteasy.plugins.server.vertx.VertxSecurityContext;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class RequestDispatcher {
    protected final SynchronousDispatcher dispatcher;
    protected final ResteasyProviderFactory providerFactory;
    protected final SecurityDomain domain;

    public RequestDispatcher(SynchronousDispatcher dispatcher, ResteasyProviderFactory providerFactory, SecurityDomain domain) {
        this.dispatcher = dispatcher;
        this.providerFactory = providerFactory;
        this.domain = domain;
    }

    public SynchronousDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public SecurityDomain getDomain() {
        return this.domain;
    }

    public ResteasyProviderFactory getProviderFactory() {
        return this.providerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Context context, HttpServerRequest req, HttpServerResponse resp, HttpRequest vertxReq, HttpResponse vertxResp, boolean handleNotFound) throws IOException {
        try {
            SecurityContext securityContext;
            ResteasyProviderFactory defaultInstance = ResteasyProviderFactory.getInstance();
            if (defaultInstance instanceof ThreadLocalResteasyProviderFactory) {
                ThreadLocalResteasyProviderFactory.push((ResteasyProviderFactory)this.providerFactory);
            }
            if (this.domain != null) {
                securityContext = this.basicAuthentication(vertxReq, vertxResp);
                if (securityContext == null) {
                    return;
                }
            } else {
                securityContext = new VertxSecurityContext();
            }
            try {
                ResteasyContext.pushContext(SecurityContext.class, (Object)securityContext);
                ResteasyContext.pushContext(Context.class, (Object)context);
                ResteasyContext.pushContext(HttpServerRequest.class, (Object)req);
                ResteasyContext.pushContext(HttpServerResponse.class, (Object)resp);
                ResteasyContext.pushContext(Vertx.class, (Object)context.owner());
                if (handleNotFound) {
                    this.dispatcher.invoke(vertxReq, vertxResp);
                } else {
                    this.dispatcher.invokePropagateNotFound(vertxReq, vertxResp);
                }
            }
            finally {
                ResteasyContext.clearContextData();
            }
        }
        finally {
            ResteasyProviderFactory defaultInstance = ResteasyProviderFactory.getInstance();
            if (defaultInstance instanceof ThreadLocalResteasyProviderFactory) {
                ThreadLocalResteasyProviderFactory.pop();
            }
        }
    }

    private SecurityContext basicAuthentication(HttpRequest request, HttpResponse response) throws IOException {
        String auth;
        List headers = request.getHttpHeaders().getRequestHeader("Authorization");
        if (!headers.isEmpty() && (auth = (String)headers.get(0)).length() > 5) {
            String type = auth.substring(0, 5);
            if ("basic".equals(type = type.toLowerCase())) {
                String cookie = auth.substring(6);
                cookie = new String(Base64.getDecoder().decode(cookie.getBytes()));
                String[] split = cookie.split(":");
                Principal user = null;
                try {
                    user = this.domain.authenticate(split[0], split[1]);
                    return new VertxSecurityContext(user, this.domain, "BASIC", true);
                }
                catch (SecurityException e) {
                    response.sendError(401);
                    return null;
                }
            }
            response.sendError(401);
            return null;
        }
        return null;
    }
}

