/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.skeleton.key.as7;

import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.jboss.logging.Logger;
import org.jboss.resteasy.skeleton.key.RSATokenVerifier;
import org.jboss.resteasy.skeleton.key.RealmConfiguration;
import org.jboss.resteasy.skeleton.key.ResourceMetadata;
import org.jboss.resteasy.skeleton.key.VerificationException;
import org.jboss.resteasy.skeleton.key.representations.AccessTokenResponse;
import org.jboss.resteasy.skeleton.key.representations.SkeletonKeyToken;
import org.jboss.resteasy.util.BasicAuthHelper;

public class ServletOAuthLogin {
    private static final Logger log = Logger.getLogger(ServletOAuthLogin.class);
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected boolean codePresent;
    protected RealmConfiguration realmInfo;
    protected int redirectPort;
    protected String tokenString;
    protected SkeletonKeyToken token;
    protected static final AtomicLong counter = new AtomicLong();

    public ServletOAuthLogin(RealmConfiguration realmInfo, HttpServletRequest request, HttpServletResponse response, int redirectPort) {
        this.request = request;
        this.response = response;
        this.realmInfo = realmInfo;
        this.redirectPort = redirectPort;
    }

    public String getTokenString() {
        return this.tokenString;
    }

    public SkeletonKeyToken getToken() {
        return this.token;
    }

    public RealmConfiguration getRealmInfo() {
        return this.realmInfo;
    }

    protected String getDefaultCookiePath() {
        String path = this.request.getContextPath();
        if ("".equals(path) || path == null) {
            path = "/";
        }
        return path;
    }

    protected String getRequestUrl() {
        return this.request.getRequestURL().toString();
    }

    protected boolean isRequestSecure() {
        return this.request.isSecure();
    }

    protected void sendError(int code) {
        try {
            this.response.sendError(code);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void sendRedirect(String url) {
        try {
            this.response.sendRedirect(url);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Cookie getCookie(String cookieName) {
        if (this.request.getCookies() == null) {
            return null;
        }
        for (Cookie cookie : this.request.getCookies()) {
            if (!cookie.getName().equals(cookieName)) continue;
            return cookie;
        }
        return null;
    }

    protected String getCookieValue(String cookieName) {
        Cookie cookie = this.getCookie(cookieName);
        if (cookie == null) {
            return null;
        }
        return cookie.getValue();
    }

    protected String getQueryParamValue(String paramName) {
        String[] params;
        String query = this.request.getQueryString();
        if (query == null) {
            return null;
        }
        for (String param : params = query.split("&")) {
            String name;
            int eq = param.indexOf(61);
            if (eq == -1 || !(name = param.substring(0, eq)).equals(paramName)) continue;
            return param.substring(eq + 1);
        }
        return null;
    }

    public String getError() {
        return this.getQueryParamValue("error");
    }

    public String getCode() {
        return this.getQueryParamValue("code");
    }

    protected void setCookie(String name, String value, String domain, String path, boolean secure) {
        Cookie cookie = new Cookie(name, value);
        if (domain != null) {
            cookie.setDomain(domain);
        }
        if (path != null) {
            cookie.setPath(path);
        }
        if (secure) {
            cookie.setSecure(true);
        }
        this.response.addCookie(cookie);
    }

    protected String getRedirectUri(String state) {
        String url = this.getRequestUrl();
        if (!this.isRequestSecure() && this.realmInfo.isSslRequired()) {
            int port = this.redirectPort;
            if (port < 0) {
                return null;
            }
            UriBuilder secureUrl = UriBuilder.fromUri((String)url).scheme("https").port(-1);
            if (port != 443) {
                secureUrl.port(port);
            }
            url = secureUrl.build(new Object[0]).toString();
        }
        return this.realmInfo.getAuthUrl().clone().queryParam("client_id", new Object[]{this.realmInfo.getClientId()}).queryParam("redirect_uri", new Object[]{url}).queryParam("state", new Object[]{state}).queryParam("login", new Object[]{"true"}).build(new Object[0]).toString();
    }

    protected String getStateCode() {
        return counter.getAndIncrement() + "/" + UUID.randomUUID().toString();
    }

    public void loginRedirect() {
        String state = this.getStateCode();
        String redirect = this.getRedirectUri(state);
        if (redirect == null) {
            this.sendError(Response.Status.FORBIDDEN.getStatusCode());
            return;
        }
        this.setCookie(this.realmInfo.getStateCookieName(), state, null, this.getDefaultCookiePath(), this.realmInfo.isSslRequired());
        this.sendRedirect(redirect);
    }

    public boolean checkStateCookie() {
        Cookie stateCookie = this.getCookie(this.realmInfo.getStateCookieName());
        if (stateCookie == null) {
            this.sendError(400);
            log.warn((Object)"No state cookie");
            return false;
        }
        Cookie reset = new Cookie(stateCookie.getName(), stateCookie.getValue());
        reset.setPath(stateCookie.getPath());
        reset.setMaxAge(0);
        this.response.addCookie(reset);
        String stateCookieValue = this.getCookieValue(this.realmInfo.getStateCookieName());
        String state = this.request.getParameter("state");
        if (state == null) {
            this.sendError(400);
            log.warn((Object)"state parameter was null");
            return false;
        }
        if (!state.equals(stateCookieValue)) {
            this.sendError(400);
            log.warn((Object)"state parameter invalid");
            log.warn((Object)("cookie: " + stateCookieValue));
            log.warn((Object)("queryParam: " + state));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resolveCode(String code) {
        AccessTokenResponse tokenResponse;
        if (this.realmInfo.isSslRequired() && !this.isRequestSecure()) {
            log.error((Object)"SSL is required");
            this.sendError(Response.Status.FORBIDDEN.getStatusCode());
            return false;
        }
        if (!this.checkStateCookie()) {
            return false;
        }
        String client_id = this.realmInfo.getClientId();
        String password = (String)this.realmInfo.getCredentials().asMap().getFirst((Object)"password");
        String authHeader = BasicAuthHelper.createHeader((String)client_id, (String)password);
        String redirectUri = this.stripOauthParametersFromRedirect();
        Form form = new Form();
        form.param("grant_type", "authorization_code").param("code", code).param("redirect_uri", redirectUri);
        Response res = this.realmInfo.getCodeUrl().request().header("Authorization", (Object)authHeader).post(Entity.form((Form)form));
        try {
            if (res.getStatus() != 200) {
                log.error((Object)"failed to turn code into token");
                this.sendError(Response.Status.FORBIDDEN.getStatusCode());
                boolean bl = false;
                return bl;
            }
            log.debug((Object)("media type: " + res.getMediaType()));
            log.debug((Object)("Content-Type header: " + res.getHeaderString("Content-Type")));
            tokenResponse = (AccessTokenResponse)res.readEntity(AccessTokenResponse.class);
        }
        finally {
            res.close();
        }
        this.tokenString = tokenResponse.getToken();
        try {
            this.token = RSATokenVerifier.verifyToken((String)this.tokenString, (ResourceMetadata)this.realmInfo.getMetadata());
            log.debug((Object)"Verification succeeded!");
        }
        catch (VerificationException e) {
            log.error((Object)"failed verification of token");
            this.sendError(Response.Status.FORBIDDEN.getStatusCode());
            return false;
        }
        this.sendRedirect(redirectUri);
        return true;
    }

    protected String stripOauthParametersFromRedirect() {
        StringBuffer buf = this.request.getRequestURL().append("?").append(this.request.getQueryString());
        UriBuilder builder = UriBuilder.fromUri((String)buf.toString()).replaceQueryParam("code", null).replaceQueryParam("state", null);
        return builder.build(new Object[0]).toString();
    }
}

