/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core;

import jakarta.json.JsonObject;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.core.client.ActiveMQClientMessageBundle;
import org.apache.activemq.artemis.core.remoting.impl.TransportConfigurationUtil;
import org.apache.activemq.artemis.utils.JsonLoader;
import org.apache.activemq.artemis.utils.UUIDGenerator;

public class TransportConfiguration
implements Serializable {
    private static final long serialVersionUID = -3994528421527392679L;
    private String name;
    private String factoryClassName;
    private Map<String, Object> params;
    private Map<String, Object> extraProps;
    private static final byte TYPE_BOOLEAN = 0;
    private static final byte TYPE_INT = 1;
    private static final byte TYPE_LONG = 2;
    private static final byte TYPE_STRING = 3;

    public JsonObject toJson() {
        return JsonLoader.createObjectBuilder().add("name", this.name).add("factoryClassName", this.factoryClassName).add("params", JsonUtil.toJsonObject(this.params)).add("extraProps", JsonUtil.toJsonObject(this.extraProps)).build();
    }

    public static String[] splitHosts(String commaSeparatedHosts) {
        if (commaSeparatedHosts == null) {
            return new String[0];
        }
        String[] hosts = commaSeparatedHosts.split(",");
        for (int i = 0; i < hosts.length; ++i) {
            hosts[i] = hosts[i].trim();
        }
        return hosts;
    }

    public TransportConfiguration() {
        this.params = new HashMap<String, Object>();
    }

    public TransportConfiguration(String className, Map<String, Object> params, String name) {
        this(className, params, name, null);
    }

    public TransportConfiguration(String className, Map<String, Object> params, String name, Map<String, Object> extraProps) {
        this.factoryClassName = className;
        this.params = params == null || params.isEmpty() ? TransportConfigurationUtil.getDefaults(className) : params;
        this.name = name;
        this.extraProps = extraProps;
    }

    public TransportConfiguration newTransportConfig(String newName) {
        return new TransportConfiguration(this.factoryClassName, this.params, newName);
    }

    public TransportConfiguration(String className, Map<String, Object> params) {
        this(className, params, UUIDGenerator.getInstance().generateStringUUID());
    }

    public TransportConfiguration(String className) {
        this(className, new HashMap<String, Object>(), UUIDGenerator.getInstance().generateStringUUID());
    }

    public String getName() {
        return this.name;
    }

    public String getFactoryClassName() {
        return this.factoryClassName;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public Map<String, Object> getExtraParams() {
        return this.extraProps;
    }

    public Map<String, Object> getCombinedParams() {
        HashMap<String, Object> combined = new HashMap<String, Object>();
        if (this.params != null) {
            combined.putAll(this.params);
        }
        if (this.extraProps != null) {
            combined.putAll(this.extraProps);
        }
        return combined;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + this.factoryClassName.hashCode();
        result = 31 * result + (this.params != null ? this.params.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransportConfiguration that = (TransportConfiguration)o;
        if (!this.isSameParams(that)) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public boolean isSameParams(TransportConfiguration that) {
        if (!this.factoryClassName.equals(that.factoryClassName)) {
            return false;
        }
        return !(this.params != null ? !this.params.equals(that.params) : that.params != null);
    }

    public boolean isEquivalent(TransportConfiguration otherConfig) {
        if (this.getFactoryClassName().equals(otherConfig.getFactoryClassName())) {
            return true;
        }
        if (this.getFactoryClassName().contains("Netty") && otherConfig.getFactoryClassName().contains("Netty")) {
            return true;
        }
        return this.getFactoryClassName().contains("InVM") && otherConfig.getFactoryClassName().contains("InVM");
    }

    public String toString() {
        StringBuilder str = new StringBuilder(TransportConfiguration.class.getSimpleName());
        str.append("(name=" + this.name + ", ");
        str.append("factory=" + (this.factoryClassName == null ? "null" : TransportConfiguration.replaceWildcardChars(this.factoryClassName)));
        str.append(") ");
        str.append(TransportConfiguration.toStringParameters(this.params, this.extraProps));
        return str.toString();
    }

    public static String toStringParameters(Map<String, Object> params, Map<String, Object> extraProps) {
        StringBuilder str = new StringBuilder();
        if (params != null) {
            String val;
            String key;
            if (!params.isEmpty()) {
                str.append("?");
            }
            boolean first = true;
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                if (!first) {
                    str.append("&");
                }
                val = (key = entry.getKey()).toLowerCase().contains("password") ? "****" : (entry.getValue() == null ? "null" : entry.getValue().toString());
                str.append(TransportConfiguration.replaceWildcardChars(key)).append('=').append(TransportConfiguration.replaceWildcardChars(val));
                first = false;
            }
            if (extraProps != null) {
                for (Map.Entry<String, Object> entry : extraProps.entrySet()) {
                    if (!first) {
                        str.append("&");
                    }
                    key = entry.getKey();
                    val = entry.getValue() == null ? "null" : entry.getValue().toString();
                    str.append(TransportConfiguration.replaceWildcardChars(key)).append('=').append(TransportConfiguration.replaceWildcardChars(val));
                    first = false;
                }
            }
        }
        return str.toString();
    }

    private void encodeMap(ActiveMQBuffer buffer, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            buffer.writeString(entry.getKey());
            Object val = entry.getValue();
            if (val instanceof Boolean) {
                buffer.writeByte((byte)0);
                buffer.writeBoolean((Boolean)val);
                continue;
            }
            if (val instanceof Integer) {
                buffer.writeByte((byte)1);
                buffer.writeInt((Integer)val);
                continue;
            }
            if (val instanceof Long) {
                buffer.writeByte((byte)2);
                buffer.writeLong((Long)val);
                continue;
            }
            if (val instanceof String) {
                buffer.writeByte((byte)3);
                buffer.writeString((String)val);
                continue;
            }
            throw ActiveMQClientMessageBundle.BUNDLE.invalidEncodeType(val);
        }
    }

    public void encode(ActiveMQBuffer buffer) {
        buffer.writeString(this.name);
        buffer.writeString(this.factoryClassName);
        buffer.writeInt(this.params == null ? 0 : this.params.size());
        if (this.params != null) {
            this.encodeMap(buffer, this.params);
        }
        if (this.extraProps != null) {
            this.encodeMap(buffer, this.extraProps);
        }
    }

    public void decode(ActiveMQBuffer buffer) {
        this.name = buffer.readString();
        this.factoryClassName = buffer.readString();
        int num = buffer.readInt();
        if (this.params == null) {
            if (num > 0) {
                this.params = new HashMap<String, Object>();
            }
        } else {
            this.params.clear();
        }
        for (int i = 0; i < num; ++i) {
            Object val;
            String key = buffer.readString();
            byte type = buffer.readByte();
            switch (type) {
                case 0: {
                    val = buffer.readBoolean();
                    break;
                }
                case 1: {
                    val = buffer.readInt();
                    break;
                }
                case 2: {
                    val = buffer.readLong();
                    break;
                }
                case 3: {
                    val = buffer.readString();
                    break;
                }
                default: {
                    throw ActiveMQClientMessageBundle.BUNDLE.invalidType(type);
                }
            }
            this.params.put(key, val);
        }
    }

    private static String replaceWildcardChars(String str) {
        return str.replace('.', '-');
    }

    public void setFactoryClassName(String factoryClassName) {
        this.factoryClassName = factoryClassName;
    }
}

