/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.utils;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;

public class TestUtilSpring {
    private static File[] resolveSpringDependencies(String ... additionalDeps) {
        PomEquippedResolveStage resolver = (PomEquippedResolveStage)Maven.resolver().loadPomFromFile("pom.xml");
        HashSet<File> runtimeDependencies = new HashSet<File>();
        try {
            File[] springDeps = ((MavenFormatStage)((MavenStrategyStage)resolver.resolve(new String[]{"org.springframework:spring-core", "org.springframework:spring-web", "org.springframework:spring-webmvc", "org.springframework:spring-context", "org.springframework:spring-expression", "org.springframework:spring-beans", "org.springframework:spring-aop"})).withTransitivity()).asFile();
            runtimeDependencies.addAll(Arrays.asList(springDeps));
            if (TestUtilSpring.includeResteasySpring()) {
                runtimeDependencies.add(((MavenFormatStage)((MavenStrategyStage)resolver.resolve("org.jboss.resteasy.spring:resteasy-spring")).withoutTransitivity()).asSingleFile());
            }
            if (additionalDeps != null && additionalDeps.length > 0) {
                File[] additional = ((MavenFormatStage)((MavenStrategyStage)resolver.resolve(additionalDeps)).withTransitivity()).asFile();
                runtimeDependencies.addAll(Arrays.asList(additional));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get artifacts from maven via Aether library", e);
        }
        return runtimeDependencies.toArray(new File[0]);
    }

    public static void addSpringLibraries(WebArchive archive) {
        archive.addAsLibraries(TestUtilSpring.resolveSpringDependencies(new String[0]));
    }

    public static void addSpringLibraries(WebArchive archive, String ... additionalDeps) {
        archive.addAsLibraries(TestUtilSpring.resolveSpringDependencies(additionalDeps));
    }

    public static String getResteasySpringVersion() {
        return System.getProperty("version.test.org.jboss.resteasy.spring");
    }

    public static boolean includeResteasySpring() {
        String value = System.getProperty("include.resteasy.spring");
        if (value == null) {
            return false;
        }
        return "".equals(value.trim()) || Boolean.parseBoolean(value);
    }
}

