/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.scanning.plugins.helpers;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

import org.jboss.scanning.spi.ScanningHandle;
import org.jboss.scanning.spi.ScanningPlugin;
import org.jboss.scanning.spi.helpers.ScanningHandleAggregator;

/**
 * Abstract scanning handle aggregator.
 *
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 */
public abstract class AbstractScanningHandleAggregator<T extends ScanningHandle, U> implements ScanningHandleAggregator<T, U>
{
   @SuppressWarnings("unchecked")
   protected U aggregate(final ScanningPlugin plugin, final Set<U> handles)
   {
      return (U)Proxy.newProxyInstance(getClass().getClassLoader(), new Class[]{plugin.getHandleInterface()}, new InvocationHandler()
      {
         public Object invoke(Object proxy, Method method, Object[] args) throws Throwable
         {
            String methodName = method.getName();
            if ("toString".equals(methodName))
               return plugin + ".handle-aggregate";
            else if ("getClass".equals(methodName))
               return plugin.getHandleInterface();
            else if ("equals".equals(methodName))
               return proxy == args[0];
            else if ("hashCode".equals(methodName))
               return proxy.hashCode();

            Object result = null;
            for (U handle : handles)
            {
               Object tmp = method.invoke(handle, args);
               if (tmp == null)
                  continue;

               if (tmp instanceof Collection)
               {
                  if (result == null)
                     result = tmp;
                  else
                     ((Collection)result).addAll(((Collection)tmp));
               }
               else if (tmp instanceof Map)
               {
                  if (result == null)
                     result = tmp;
                  else
                     ((Map)result).putAll(((Map)tmp));
               }
               else
               {
                  result = tmp;
                  break;
               }
            }
            return result;
         }
      });
   }
}
