/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.scanning.plugins.helpers;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

import org.jboss.deployers.spi.deployer.helpers.AttachmentLocator;
import org.jboss.deployers.structure.spi.DeploymentUnit;

/**
 * The lazy utils proxy.
 *
 * @param <T> exact util type
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 */
class LazyUtilsProxyHandler<T> implements InvocationHandler
{
   private DeploymentUnit unit;
   private Class<T> type;
   private T util;

   public LazyUtilsProxyHandler(DeploymentUnit unit, Class<T> type)
   {
      if (unit == null)
         throw new IllegalArgumentException("Null unit");
      if (type == null)
         throw new IllegalArgumentException("Null util type");

      this.unit = unit;
      this.type = type;
   }

   private T getUtil()
   {
      if (util == null)
      {
         T tmp = AttachmentLocator.searchAncestors(unit, type);
         if (tmp == null)
            throw new IllegalArgumentException("No such util: " + type);
         util = tmp;
      }
      return util;
   }

   public Object invoke(Object proxy, Method method, Object[] args) throws Throwable
   {
      return method.invoke(getUtil(), args);
   }
}