/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.scanning.plugins.visitor;

import java.util.HashSet;
import java.util.Set;

import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.classloading.spi.visitor.ResourceVisitor;
import org.jboss.logging.Logger;

/**
 * Set of ignored errors.
 * If it's not ignored, it's thrown fwd wrapped as RuntimeException.
 *
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 */
public class IgnoreSetErrorHandler implements ErrorHandler
{
   private static final Logger log = Logger.getLogger(IgnoreSetErrorHandler.class);

   @SuppressWarnings({"unchecked"})
   private Set<Class<Throwable>> ignore = new HashSet<Class<Throwable>>();

   public void handleError(ResourceVisitor visitor, ResourceContext resource, Throwable t)
   {
      for (Class<Throwable> i : ignore)
      {
         if (i.isInstance(t))
         {
            if (log.isTraceEnabled())
               log.trace("Ignoring resource (" + resource + ") visitor (" + visitor + ") error: " + t);

            return;
         }
      }
      throw new RuntimeException(t);
   }

   public void addIgnored(Class<Throwable> t)
   {
      if (t == null)
         throw new IllegalArgumentException("Null class");

      ignore.add(t);
   }

   public void removeIgnored(Class<Throwable> t)
   {
      if (t == null)
         throw new IllegalArgumentException("Null class");

      ignore.remove(t);
   }
}