/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.scanning.annotations.plugins;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.net.URL;

import org.jboss.classloading.spi.visitor.ClassFilter;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.scanning.plugins.helpers.ResourceOwnerFinder;
import org.jboss.scanning.plugins.visitor.ClassHierarchyResourceVisitor;
import org.jboss.scanning.plugins.visitor.ReflectProvider;

/**
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 */
public class GenericAnnotationVisitor extends ClassHierarchyResourceVisitor
{
   /** The mutable repository */
   private MutableAnnotationRepository repository;

   public GenericAnnotationVisitor(ReflectProvider provider, ResourceOwnerFinder finder, MutableAnnotationRepository repository)
   {
      super(provider, finder);
      if (repository == null)
         throw new IllegalArgumentException("Null repository");
      this.repository = repository;
   }

   protected boolean isRelevant(ClassInfo classInfo)
   {
      return repository.isAlreadyChecked(classInfo.getName()) == false;
   }

   public ResourceFilter getFilter()
   {
      return ClassFilter.INSTANCE;
   }

   @Override
   protected void handleAnnotations(ElementType type, Signature signature, Annotation[] annotations, String className, URL ownerURL)
   {
      if (annotations != null && annotations.length > 0)
      {
         for (Annotation annotation : annotations)
         {
            repository.putAnnotation(annotation, type, className, signature, ownerURL);
         }
      }
   }
}
