/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.hibernate;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.ejb.packaging.NamedInputStream;
import org.hibernate.ejb.packaging.Scanner;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloading.plugins.vfs.PackageVisitor;
import org.jboss.classloading.plugins.visitor.FederatedResourceVisitor;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.metadata.ExportAll;
import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.classloading.spi.visitor.ResourceVisitor;
import org.jboss.deployers.spi.deployer.helpers.AttachmentLocator;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.scanning.hibernate.ClassesVisitor;
import org.jboss.scanning.hibernate.PatternFilter;
import org.jboss.scanning.hibernate.TempAnnotationVisitor;
import org.jboss.scanning.plugins.helpers.DeploymentUtilsFactory;
import org.jboss.scanning.plugins.helpers.MergeUtils;
import org.jboss.scanning.plugins.helpers.ResourceOwnerFinder;
import org.jboss.scanning.plugins.helpers.WeakClassLoaderHolder;
import org.jboss.scanning.spi.ScanningHandle;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScannerImpl
extends WeakClassLoaderHolder
implements Scanner,
ScanningHandle<ScannerImpl> {
    private Map<String, Set<Package>> packages = new HashMap<String, Set<Package>>();
    private Map<String, Set<String>> pckgCache = new HashMap<String, Set<String>>();
    private Map<String, Map<Class<? extends Annotation>, Set<String>>> classes = new HashMap<String, Map<Class<? extends Annotation>, Set<String>>>();
    private Map<String, Map<String, Set<NamedInputStream>>> files = new HashMap<String, Map<String, Set<NamedInputStream>>>();
    private DeploymentUnit unit;
    private ResourceOwnerFinder finder;
    private boolean allowQueryInvocationSearch;
    private boolean cacheNewResults;

    private static DeploymentUnit check(DeploymentUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Null unit");
        }
        return unit;
    }

    public ScannerImpl(DeploymentUnit unit) {
        super(ScannerImpl.check(unit).getClassLoader());
        this.unit = unit;
        this.finder = DeploymentUtilsFactory.getFinder((DeploymentUnit)unit);
    }

    protected void cleanup() {
        this.packages.clear();
        this.pckgCache.clear();
        this.classes.clear();
        this.files.clear();
    }

    URL getOwnerURL(ResourceContext resource) {
        return this.finder.findOwnerURL(resource);
    }

    Package loadPackage(String pckg) {
        return this.loadClass(pckg + ".package-info").getPackage();
    }

    void addPackage(URL url, String pckg) {
        String path = url.getPath();
        Set<String> cache = this.pckgCache.get(path);
        if (cache != null) {
            if (cache.contains(pckg)) {
                return;
            }
        } else {
            cache = new HashSet<String>();
            this.pckgCache.put(path, cache);
        }
        cache.add(pckg);
        Set<Package> pckgs = this.packages.get(path);
        if (pckgs == null) {
            pckgs = new HashSet<Package>();
            this.packages.put(path, pckgs);
        }
        pckgs.add(this.loadPackage(pckg));
    }

    void addClass(URL url, Class<? extends Annotation> annotation, String clazz) {
        Set<String> cls;
        String path = url.getPath();
        Map<Class<? extends Annotation>, Set<String>> map = this.classes.get(path);
        if (map == null) {
            map = new HashMap<Class<? extends Annotation>, Set<String>>();
            this.classes.put(path, map);
        }
        if ((cls = map.get(annotation)) == null) {
            cls = new HashSet<String>();
            map.put(annotation, cls);
        }
        cls.add(clazz);
    }

    void addFile(URL url, String pattern, NamedInputStream nis) {
        Set<NamedInputStream> nims;
        String path = url.getPath();
        Map<String, Set<NamedInputStream>> map = this.files.get(path);
        if (map == null) {
            map = new HashMap<String, Set<NamedInputStream>>();
            this.files.put(path, map);
        }
        if ((nims = map.get(pattern)) == null) {
            nims = new HashSet<NamedInputStream>();
            map.put(pattern, nims);
        }
        nims.add(nis);
    }

    public void merge(ScannerImpl subHandle) {
        MergeUtils.singleMerge(this.packages, subHandle.getPackages());
        MergeUtils.doubleMerge(this.classes, subHandle.getClasses());
        MergeUtils.doubleMerge(this.files, subHandle.getFiles());
    }

    public Set<Package> getPackagesInJar(URL jarToScan, Set<Class<? extends Annotation>> annotationsToLookFor) {
        if (jarToScan == null) {
            throw new IllegalArgumentException("Null jar to scan url");
        }
        if (annotationsToLookFor == null) {
            throw new IllegalArgumentException("Null annotations to look for");
        }
        if (annotationsToLookFor.size() > 0) {
            throw new AssertionFailure("Improper use of MC Scanner: must not filter packages");
        }
        String path = jarToScan.getPath();
        Set<Package> p = this.packages.get(path);
        if (p == null && this.allowQueryInvocationSearch) {
            Module module = (Module)AttachmentLocator.searchAncestors((DeploymentUnit)this.unit, Module.class);
            if (module == null) {
                throw new IllegalArgumentException("No such module: " + this.unit);
            }
            p = new HashSet<Package>();
            VirtualFile root = this.getFile(jarToScan);
            Set pckgs = PackageVisitor.determineAllPackages((VirtualFile[])new VirtualFile[]{root}, null, (ExportAll)module.getExportAll(), (ClassFilter)module.getIncluded(), (ClassFilter)module.getExcluded(), (ClassFilter)module.getExcludedExport());
            for (String pckg : pckgs) {
                Package pck = this.loadPackage(pckg);
                p.add(pck);
            }
            if (this.cacheNewResults) {
                this.packages.put(path, p);
            }
        }
        this.pckgCache.remove(path);
        return p != null ? Collections.unmodifiableSet(p) : Collections.emptySet();
    }

    public Set<Class<?>> getClassesInJar(URL jartoScan, Set<Class<? extends Annotation>> annotationsToLookFor) {
        if (jartoScan == null) {
            throw new IllegalArgumentException("Null jar to scan url");
        }
        if (annotationsToLookFor == null) {
            throw new IllegalArgumentException("Null annotations to look for");
        }
        HashSet<String> strings = new HashSet<String>();
        if (annotationsToLookFor.isEmpty()) {
            Module module = (Module)AttachmentLocator.searchAncestors((DeploymentUnit)this.unit, Module.class);
            if (module == null) {
                throw new IllegalArgumentException("No such module: " + this.unit);
            }
            ClassesVisitor visitor = new ClassesVisitor(strings);
            module.visit((ResourceVisitor)visitor, visitor.getFilter(), null, new URL[]{jartoScan});
        } else {
            HashSet<Class<? extends Annotation>> missingCacheAnnotations = new HashSet<Class<? extends Annotation>>();
            Map<Class<? extends Annotation>, Set<String>> map = this.classes.get(jartoScan.getPath());
            if (map != null) {
                for (Class<? extends Annotation> annClass : annotationsToLookFor) {
                    Set<String> s = map.get(annClass);
                    if (s != null) {
                        strings.addAll(s);
                        continue;
                    }
                    missingCacheAnnotations.add(annClass);
                }
            } else {
                missingCacheAnnotations.addAll(annotationsToLookFor);
            }
            if (this.allowQueryInvocationSearch && !missingCacheAnnotations.isEmpty()) {
                Module module = (Module)AttachmentLocator.searchAncestors((DeploymentUnit)this.unit, Module.class);
                if (module == null) {
                    throw new IllegalArgumentException("No such module: " + this.unit);
                }
                HashMap temp = new HashMap();
                ResourceVisitor[] visitors = new ResourceVisitor[missingCacheAnnotations.size()];
                int i = 0;
                for (Class clazz : missingCacheAnnotations) {
                    HashSet tmpStrings = new HashSet();
                    temp.put(clazz, tmpStrings);
                    visitors[i++] = new TempAnnotationVisitor(null, clazz, strings);
                }
                FederatedResourceVisitor visitor = new FederatedResourceVisitor(visitors, null, null);
                module.visit((ResourceVisitor)visitor, visitor.getFilter(), null, new URL[]{jartoScan});
                if (this.cacheNewResults) {
                    if (map != null) {
                        map.putAll(temp);
                    } else {
                        this.classes.put(jartoScan.getPath(), temp);
                    }
                }
                for (Set vals : temp.values()) {
                    strings.addAll(vals);
                }
            }
        }
        HashSet result = new HashSet();
        for (String clazz : strings) {
            result.add(this.loadClass(clazz));
        }
        return result;
    }

    public Set<NamedInputStream> getFilesInJar(URL jartoScan, Set<String> filePatterns) {
        if (jartoScan == null) {
            throw new IllegalArgumentException("Null jar to scan url");
        }
        if (filePatterns == null) {
            throw new IllegalArgumentException("Null file patterns to look for");
        }
        HashSet<NamedInputStream> result = new HashSet<NamedInputStream>();
        String path = jartoScan.getPath();
        Map<String, Set<NamedInputStream>> map = this.files.get(path);
        if (map != null) {
            this.findFiles(jartoScan, filePatterns, map, result);
        } else {
            map = new HashMap<String, Set<NamedInputStream>>();
            this.findFiles(jartoScan, filePatterns, map, result);
            if (this.cacheNewResults) {
                this.files.put(path, map);
            }
        }
        return result;
    }

    private void findFiles(URL jartoScan, Set<String> filePatterns, Map<String, Set<NamedInputStream>> map, Set<NamedInputStream> result) {
        if (filePatterns.isEmpty()) {
            for (Set<NamedInputStream> nims : map.values()) {
                result.addAll(nims);
            }
        } else {
            VirtualFile root = null;
            for (String pattern : filePatterns) {
                Set<NamedInputStream> niss = map.get(pattern);
                if (niss == null && this.allowQueryInvocationSearch) {
                    if (root == null) {
                        root = this.getFile(jartoScan);
                    }
                    try {
                        List children = root.getChildrenRecursively((VirtualFileFilter)new PatternFilter(pattern));
                        niss = this.toNIS(children);
                        if (this.cacheNewResults) {
                            map.put(pattern, niss);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (niss == null) continue;
                result.addAll(niss);
            }
        }
    }

    private Set<NamedInputStream> toNIS(Iterable<VirtualFile> files) {
        try {
            HashSet<NamedInputStream> result = new HashSet<NamedInputStream>();
            for (VirtualFile file : files) {
                NamedInputStream nis = new NamedInputStream(file.getName(), file.openStream());
                result.add(nis);
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<NamedInputStream> getFilesInClasspath(URL jartoScan, Set<String> filePatterns) {
        throw new RuntimeException("Not yet implemented");
    }

    public String getUnqualifiedJarName(URL jarUrl) {
        if (jarUrl == null) {
            throw new IllegalArgumentException("Null jar url");
        }
        VirtualFile file = this.getFile(jarUrl);
        return file.getName();
    }

    private VirtualFile getFile(URL url) {
        try {
            return VFS.getChild((URL)url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setAllowQueryInvocationSearch(boolean allowQueryInvocationSearch) {
        this.allowQueryInvocationSearch = allowQueryInvocationSearch;
    }

    public void setCacheNewResults(boolean cacheNewResults) {
        this.cacheNewResults = cacheNewResults;
    }

    Map<String, Set<Package>> getPackages() {
        return this.packages;
    }

    Map<String, Map<Class<? extends Annotation>, Set<String>>> getClasses() {
        return this.classes;
    }

    Map<String, Map<String, Set<NamedInputStream>>> getFiles() {
        return this.files;
    }
}

