/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.hibernate;

import java.lang.annotation.Annotation;
import java.net.URL;
import org.jboss.classloading.spi.visitor.ClassFilter;
import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.scanning.hibernate.ScannerImpl;
import org.jboss.scanning.plugins.visitor.ReflectProvider;
import org.jboss.scanning.plugins.visitor.ReflectResourceVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleAnnotationVisitor
extends ReflectResourceVisitor {
    private final Class<? extends Annotation> annotation;
    private final ScannerImpl scanner;

    public SingleAnnotationVisitor(ReflectProvider provider, Class<? extends Annotation> annotation, ScannerImpl scanner) {
        super(provider);
        if (annotation == null) {
            throw new IllegalArgumentException("Null annotation");
        }
        if (scanner == null) {
            throw new IllegalArgumentException("Null scanner");
        }
        this.annotation = annotation;
        this.scanner = scanner;
    }

    public ResourceFilter getFilter() {
        return ClassFilter.INSTANCE;
    }

    protected void doVisit(ResourceContext resource) throws Throwable {
        ClassInfo classInfo = this.getClassInfo(resource);
        if (classInfo.isAnnotationPresent(this.annotation)) {
            URL ownerURL = this.scanner.getOwnerURL(resource);
            this.scanner.addClass(ownerURL, this.annotation, classInfo.getName());
        }
    }
}

