/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.web.plugins;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.jboss.scanning.annotations.spi.AnnotationIndex;
import org.jboss.scanning.annotations.spi.Element;
import org.jboss.scanning.hierarchy.spi.HierarchyIndex;
import org.jboss.scanning.web.spi.ResourcesIndex;
import org.jboss.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResourcesIndex
implements ResourcesIndex {
    private AnnotationIndex annotations;
    private HierarchyIndex hierarchy;

    public DefaultResourcesIndex(AnnotationIndex annotations, HierarchyIndex hierarchy) {
        if (annotations == null) {
            throw new IllegalArgumentException("Null annotations index");
        }
        if (hierarchy == null) {
            throw new IllegalArgumentException("Null hierarchy index");
        }
        this.annotations = annotations;
        this.hierarchy = hierarchy;
    }

    @Override
    public <A extends Annotation> Set<Class<?>> getAnnotatedClasses(VirtualFile cpEntry, Class<A> annotationToLookFor) {
        if (cpEntry == null) {
            throw new IllegalArgumentException("Null cp entry");
        }
        if (annotationToLookFor == null) {
            throw new IllegalArgumentException("Null annotation class");
        }
        URL url = DefaultResourcesIndex.toURL(cpEntry);
        Set<Element<A, AnnotatedElement>> elements = this.annotations.getAnnotatedClasses(url, annotationToLookFor, null);
        HashSet results = new HashSet();
        for (Element<A, AnnotatedElement> elt : elements) {
            results.add(elt.getOwner());
        }
        return results;
    }

    @Override
    public <T> Set<Class<? extends T>> getInheritedClasses(VirtualFile cpEntry, Class<T> superTypeToLookFor) {
        if (cpEntry == null) {
            throw new IllegalArgumentException("Null cp entry");
        }
        if (superTypeToLookFor == null) {
            throw new IllegalArgumentException("Null super type");
        }
        return this.hierarchy.getSubClassesOf(DefaultResourcesIndex.toURL(cpEntry), superTypeToLookFor);
    }

    protected static URL toURL(VirtualFile file) {
        try {
            return file.toURL();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

