/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.hierarchy.plugins;

import java.net.URL;
import org.jboss.classloading.spi.visitor.ClassFilter;
import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.InterfaceInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.scanning.hierarchy.plugins.HierarchyIndexImpl;
import org.jboss.scanning.plugins.helpers.ResourceOwnerFinder;
import org.jboss.scanning.plugins.visitor.ReflectProvider;
import org.jboss.scanning.plugins.visitor.ReflectResourceVisitor;

public class HierarchyTypeVisitor
extends ReflectResourceVisitor {
    private ResourceOwnerFinder finder;
    private HierarchyIndexImpl index;
    private TypeInfo OBJECT;

    public HierarchyTypeVisitor(ReflectProvider provider, ResourceOwnerFinder finder, HierarchyIndexImpl index) {
        super(provider);
        if (finder == null) {
            throw new IllegalArgumentException("Null finder");
        }
        if (index == null) {
            throw new IllegalArgumentException("Null index");
        }
        this.finder = finder;
        this.index = index;
    }

    public ResourceFilter getFilter() {
        return ClassFilter.INSTANCE;
    }

    protected void handleClass(ResourceContext resource, ClassInfo classInfo) throws Exception {
        URL ownerURL = this.finder.findOwnerURL(resource);
        String path = HierarchyIndexImpl.fixPath(ownerURL.getPath());
        this.handleInterfaces(path, classInfo, classInfo);
        this.recurse(path, classInfo, classInfo.getSuperclass());
    }

    private void recurse(String path, ClassInfo ci, ClassInfo sub) {
        if (sub == null) {
            return;
        }
        if (this.OBJECT == null) {
            this.OBJECT = sub.getTypeInfoFactory().getTypeInfo(Object.class);
        }
        if (sub == this.OBJECT) {
            return;
        }
        this.index.putInfo(path, (TypeInfo)ci, new TypeInfo[]{sub});
        this.handleInterfaces(path, ci, sub);
        this.recurse(path, ci, sub.getSuperclass());
    }

    private void handleInterfaces(String path, ClassInfo ci, ClassInfo ref) {
        InterfaceInfo[] ifaces = ref.getInterfaces();
        if (ifaces != null) {
            for (InterfaceInfo ii : ifaces) {
                this.recurse(path, ci, (ClassInfo)ii);
            }
        }
    }
}

