/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.scanning.hibernate;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Set;

import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.scanning.plugins.DeploymentScanningPluginFactory;
import org.jboss.scanning.spi.ScanningPlugin;

import org.hibernate.ejb.packaging.Scanner;

/**
 * Hibernate's scanning plugin factory.
 *
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 */
public class HibernateScanningPluginFactory implements DeploymentScanningPluginFactory<ScannerImpl, Scanner>
{
   /** The patterns */
   private Set<String> patterns;

   /** The annotations */
   private Set<Class<? extends Annotation>> annotations;

   public boolean isRelevant(DeploymentUnit unit)
   {
      return unit.isAttachmentPresent("org.jboss.metadata.jpa.spec.PersistenceMetaData");
   }

   public String getPluginOutput()
   {
      return Scanner.class.getName();
   }

   public ScanningPlugin<ScannerImpl, Scanner> create(DeploymentUnit unit)
   {
      return new HibernateScanningPlugin(unit, this);
   }

   public void start()
   {
      if (patterns == null)
         throw new IllegalArgumentException("Null patterns");
      if (annotations == null)
         throw new IllegalArgumentException("Null annotations");
   }

   public Set<String> getPatterns()
   {
      if (patterns != null)
         return Collections.unmodifiableSet(patterns);
      else
         return null;
   }

   public void setPatterns(Set<String> patterns)
   {
      this.patterns = patterns;
   }

   public Set<Class<? extends Annotation>> getAnnotations()
   {
      if (annotations != null)
         return Collections.unmodifiableSet(annotations);
      else
         return null;
   }

   public void setAnnotations(Set<Class<? extends Annotation>> annotations)
   {
      this.annotations = annotations;
   }
}