/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.scanning.hibernate;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

import org.jboss.classloading.spi.visitor.ClassFilter;
import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.scanning.plugins.visitor.JavassistReflectProvider;
import org.jboss.scanning.plugins.visitor.ReflectProvider;
import org.jboss.scanning.plugins.visitor.ReflectResourceVisitor;

/**
 * Hibernate's temp annotation visitor.
 *
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 */
class TempAnnotationVisitor extends ReflectResourceVisitor
{
   private final Class<? extends Annotation> annotation;
   private Set<String> strings = new HashSet<String>();

   public TempAnnotationVisitor(ReflectProvider provider, Class<? extends Annotation> annotation, Set<String> strings)
   {
      super(provider != null ? provider : new JavassistReflectProvider());

      if (annotation == null)
         throw new IllegalArgumentException("Null annotation");
      if (strings == null)
         strings = new HashSet<String>();

      this.annotation = annotation;
      this.strings = strings;
   }

   public ResourceFilter getFilter()
   {
      return ClassFilter.INSTANCE;
   }

   @Override
   protected void doVisit(ResourceContext resource) throws Throwable
   {
      ClassInfo classInfo = getClassInfo(resource);
      if (classInfo.isAnnotationPresent(annotation))
      {
         strings.add(classInfo.getName());
      }
   }

   public Set<String> getStrings()
   {
      return strings;
   }
}