/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.scanning.annotations.plugins;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.net.URL;

import org.jboss.metadata.spi.signature.Signature;
import org.jboss.scanning.annotations.spi.AnnotationIndex;
import org.jboss.scanning.plugins.helpers.WeakClassLoaderHolder;

/**
 * Mutable annotation repository.
 *
 * @author <a href="mailto:ales.justin@jboss.com">Ales Justin</a>
 */
public abstract class MutableAnnotationRepository extends WeakClassLoaderHolder implements AnnotationIndex
{
   private static final long serialVersionUID = 1l;

   /**
    * Should only be used for de-serialization.
    */
   public MutableAnnotationRepository()
   {
      super();
   }

   protected MutableAnnotationRepository(ClassLoader classLoader)
   {
      super(classLoader);
   }

   /**
    * Put the annotation info.
    *
    * @param annotation the annotation
    * @param type       the annotation type
    * @param className  the class name
    * @param signature  the signature
    * @param ownerURL   the class owner url
    */
   abstract void putAnnotation(Annotation annotation, ElementType type, String className, Signature signature, URL ownerURL);

   /**
    * Was class name already checked.
    *
    * @param className the class name
    * @return true if already checked, false otherwise
    */
   abstract boolean isAlreadyChecked(String className);

   /**
    * Add class implementing interface annotated with annotation.
    *
    * @param annotation the annotation name
    * @param className the class name
    */
   abstract void addClassImplementingInterfaceAnnotatedWith(String annotation, String className);
}