/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.scanning.hibernate;

import java.net.URL;

import org.jboss.classloading.spi.visitor.ClassFilter;
import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.classloading.spi.visitor.ResourceVisitor;

/**
 * Hibernate's package visitor.
 *
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 */
public class PackageVisitor implements ResourceVisitor
{
   private final ScannerImpl scanner;

   public PackageVisitor(ScannerImpl scanner)
   {
      if (scanner == null)
         throw new IllegalArgumentException("Null scanner");

      this.scanner = scanner;
   }

   public ResourceFilter getFilter()
   {
      return ClassFilter.INSTANCE;
   }

   public void visit(ResourceContext resource)
   {
      URL ownerURL = scanner.getOwnerURL(resource);
      String className = resource.getClassName();
      scanner.addPackage(ownerURL, className.substring(0, className.lastIndexOf(".")));
   }
}