/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.scanning.hierarchy.plugins;

import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.scanning.hierarchy.spi.HierarchyIndex;
import org.jboss.scanning.plugins.DeploymentScanningPluginFactory;
import org.jboss.scanning.plugins.helpers.DeploymentUtilsFactory;
import org.jboss.scanning.plugins.helpers.ResourceOwnerFinder;
import org.jboss.scanning.plugins.visitor.ErrorHandler;
import org.jboss.scanning.plugins.visitor.ReflectProvider;
import org.jboss.scanning.spi.ScanningPlugin;
import org.jboss.util.JBossObject;

/**
 * Default resource index.
 *
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 */
public class HierarchyIndexScanningPluginFactory implements DeploymentScanningPluginFactory<HierarchyIndexImpl, HierarchyIndex>
{
   private String attachmentKey;

   public HierarchyIndexScanningPluginFactory()
   {
   }

   public HierarchyIndexScanningPluginFactory(String attachmentKey)
   {
      this.attachmentKey = attachmentKey;
   }

   public boolean isRelevant(DeploymentUnit unit)
   {
      return attachmentKey == null || unit.isAttachmentPresent(attachmentKey);
   }

   public String getPluginOutput()
   {
      return HierarchyIndex.class.getName();
   }

   public ScanningPlugin<HierarchyIndexImpl, HierarchyIndex> create(DeploymentUnit unit)
   {
      ReflectProvider provider = DeploymentUtilsFactory.getProvider(unit);
      ResourceOwnerFinder finder = DeploymentUtilsFactory.getFinder(unit);
      ErrorHandler handler = DeploymentUtilsFactory.getHandler(unit);
      return new HierarchyIndexScanningPlugin(provider, finder, unit.getClassLoader(), handler);
   }

   @Override
   public int hashCode()
   {
      return attachmentKey == null ? 0 : attachmentKey.hashCode();
   }

   @Override
   public boolean equals(Object obj)
   {
      if (obj instanceof HierarchyIndexScanningPluginFactory == false)
         return false;

      HierarchyIndexScanningPluginFactory factory = (HierarchyIndexScanningPluginFactory) obj;
      return JBossObject.equals(attachmentKey, factory.attachmentKey);
   }
}