/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces.config;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import org.jboss.logging.Logger;

public class FacesServletInitializer
implements ServletContainerInitializer {
    private final transient Logger log = Logger.getLogger((String)FacesServletInitializer.class.getName());
    private static final String FACES_SERVLET_CLASS_NAME = "javax.faces.webapp.FacesServlet";
    private static final String FACES_SERVLET_NAME = "FacesServlet";
    private static final String[] FACES_SERVLET_MAPPINGS = new String[]{"/faces/*", "*.jsf", "*.faces"};

    public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {
        if (!this.isFacesServletConfigured(ctx)) {
            this.registerFacesServlet(ctx);
        }
    }

    private void registerFacesServlet(ServletContext ctx) {
        this.log.info((Object)("Auto-registering FacesServlet with mappings: " + Arrays.asList(FACES_SERVLET_MAPPINGS)));
        ServletRegistration.Dynamic facesServlet = ctx.addServlet(FACES_SERVLET_NAME, FACES_SERVLET_CLASS_NAME);
        facesServlet.addMapping(FACES_SERVLET_MAPPINGS);
    }

    private boolean isFacesServletConfigured(ServletContext ctx) {
        Map servletRegistrations = ctx.getServletRegistrations();
        for (ServletRegistration registration : servletRegistrations.values()) {
            this.log.debugf("Servlet %s is registered", (Object)registration.getClassName());
            if (!FACES_SERVLET_CLASS_NAME.equals(registration.getClassName())) continue;
            return true;
        }
        return false;
    }
}

