/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.assistant.evaluator.impl.pullrequest;

import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jboss.set.aphrodite.domain.Patch;
import org.jboss.set.assistant.evaluator.Evaluator;
import org.jboss.set.assistant.evaluator.EvaluatorContext;

public class UpstreamEvaluator
implements Evaluator {
    private Pattern UPSTREAM_NOT_REQUIRED = Pattern.compile(".*no.*upstream.*required.*", 2);

    @Override
    public String name() {
        return "Upstream Evaluator";
    }

    @Override
    public void eval(EvaluatorContext context, Map<String, Object> data) {
        Patch patch = context.getPatch();
        Set<Patch> related = context.getRelated();
        if (!this.UPSTREAM_NOT_REQUIRED.matcher(patch.getBody()).find() && !related.isEmpty()) {
            data.put("messages", "missing upstream issue link");
        }
    }
}

