/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.assistant.evaluator.impl.payload;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.naming.NameNotFoundException;
import org.jboss.set.aphrodite.Aphrodite;
import org.jboss.set.aphrodite.domain.CommitStatus;
import org.jboss.set.aphrodite.domain.Issue;
import org.jboss.set.aphrodite.domain.PatchType;
import org.jboss.set.aphrodite.domain.PullRequest;
import org.jboss.set.aphrodite.spi.NotFoundException;
import org.jboss.set.assistant.PatchHomeService;
import org.jboss.set.assistant.data.payload.AssociatedPullRequest;
import org.jboss.set.assistant.evaluator.PayloadEvaluator;
import org.jboss.set.assistant.evaluator.PayloadEvaluatorContext;

public class AssociatedPullRequestEvaluator
implements PayloadEvaluator {
    private static final Logger logger = Logger.getLogger(AssociatedPullRequestEvaluator.class.getCanonicalName());
    public static final String KEY = "associatedPullRequest";
    public static final String KEY_UNRELATED = "associatedUnrelatedPullRequest";

    @Override
    public String name() {
        return "Associate PullRequest Evaluator";
    }

    @Override
    public void eval(PayloadEvaluatorContext context, Map<String, Object> data) {
        Optional<CommitStatus> commitStatus;
        boolean isNoUpstreamRequired;
        Issue dependencyIssue = context.getIssue();
        Stream allPatches = Stream.empty();
        List<PullRequest> allPullRequests = Collections.emptyList();
        try {
            allPatches = dependencyIssue.getPatches();
        }
        catch (NameNotFoundException e2) {
            logger.log(Level.SEVERE, "Can not get patch service due to : ", e2);
        }
        Aphrodite aphrodite = context.getAphrodite();
        allPullRequests = allPatches.filter(e -> e.getPatchType().equals((Object)PatchType.PULLREQUEST)).map(e -> {
            URL url = e.getUrl();
            try {
                return aphrodite.getPullRequest(url);
            }
            catch (NotFoundException ex) {
                logger.log(Level.WARNING, "Can not get pull request from url : " + url + " due to : " + (Object)((Object)ex));
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        org.jboss.set.aphrodite.domain.Stream stream = context.getStream();
        Collection<PullRequest> relatedPullRequests = PatchHomeService.filterRelatedPatch(allPullRequests, stream);
        allPullRequests.removeAll(relatedPullRequests);
        List<PullRequest> unrelatedPullRequests = allPullRequests;
        ArrayList<AssociatedPullRequest> relatedDataList = new ArrayList<AssociatedPullRequest>();
        ArrayList<AssociatedPullRequest> unrelatedDataList = new ArrayList<AssociatedPullRequest>();
        for (PullRequest pullRequest : relatedPullRequests) {
            isNoUpstreamRequired = PatchHomeService.isNoUpstreamRequired(pullRequest);
            commitStatus = PatchHomeService.retrieveCommitStatus(pullRequest);
            relatedDataList.add(new AssociatedPullRequest(pullRequest.getId(), pullRequest.getURL(), pullRequest.getCodebase().getName(), pullRequest.getState().toString(), commitStatus.orElse(CommitStatus.UNKNOWN).toString(), isNoUpstreamRequired));
        }
        data.put(KEY, relatedDataList);
        for (PullRequest pullRequest : unrelatedPullRequests) {
            isNoUpstreamRequired = PatchHomeService.isNoUpstreamRequired(pullRequest);
            commitStatus = PatchHomeService.retrieveCommitStatus(pullRequest);
            unrelatedDataList.add(new AssociatedPullRequest(pullRequest.getId(), pullRequest.getURL(), pullRequest.getCodebase().getName(), pullRequest.getState().toString(), commitStatus.orElse(CommitStatus.UNKNOWN).toString(), isNoUpstreamRequired));
        }
        data.put(KEY_UNRELATED, unrelatedDataList);
    }
}

