/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.assistant.evaluator.impl.pullrequest;

import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.set.aphrodite.Aphrodite;
import org.jboss.set.aphrodite.domain.PullRequest;
import org.jboss.set.aphrodite.domain.Repository;
import org.jboss.set.aphrodite.domain.StreamComponent;
import org.jboss.set.aphrodite.spi.NotFoundException;
import org.jboss.set.assistant.Util;
import org.jboss.set.assistant.data.LinkData;
import org.jboss.set.assistant.evaluator.Evaluator;
import org.jboss.set.assistant.evaluator.EvaluatorContext;

public class RepositoryEvaluator
implements Evaluator {
    private static Logger logger = Logger.getLogger(RepositoryEvaluator.class.getCanonicalName());

    @Override
    public String name() {
        return "Repository evaluator";
    }

    @Override
    public void eval(EvaluatorContext context, Map<String, Object> data) {
        Repository repository = context.getRepository();
        Aphrodite aphrodite = context.getAphrodite();
        PullRequest pullRequest = context.getPullRequest();
        Optional<String> componentName = Optional.of("N/A");
        URI uri = Util.convertURLtoURI(pullRequest.getRepository().getURL());
        if (uri != null) {
            try {
                StreamComponent streamComponent = aphrodite.getComponentBy(uri, pullRequest.getCodebase());
                componentName = Optional.of(streamComponent.getName());
            }
            catch (NotFoundException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
            data.put("repository", new LinkData(componentName.get(), repository.getURL()));
        }
    }
}

