/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.assistant;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.set.aphrodite.Aphrodite;
import org.jboss.set.aphrodite.domain.spi.IssueHome;
import org.jboss.set.aphrodite.domain.spi.PatchHome;
import org.jboss.set.aphrodite.domain.spi.PullRequestHome;
import org.jboss.set.aphrodite.issue.trackers.jira.JiraIssueHomeImpl;
import org.jboss.set.aphrodite.repository.services.github.GithubPullRequestHomeService;
import org.jboss.set.aphrodite.simplecontainer.SimpleContainer;
import org.jboss.set.aphrodite.spi.AphroditeException;
import org.jboss.set.assistant.PatchHomeService;
import org.jboss.set.assistant.ViolationHome;
import org.jboss.set.assistant.ViolationHomeService;

public class AssistantClient {
    private static Logger logger = Logger.getLogger(AssistantClient.class.getCanonicalName());
    private static final SimpleContainer simpleContainer = (SimpleContainer)SimpleContainer.instance();
    private static Aphrodite aphrodite;

    private AssistantClient() {
        logger.info("starting AssistantClient.");
    }

    public static synchronized Aphrodite getAphrodite() throws AphroditeException {
        if (aphrodite == null) {
            aphrodite = Aphrodite.instance();
        }
        return aphrodite;
    }

    static {
        try {
            simpleContainer.register(Aphrodite.class.getSimpleName(), (Object)AssistantClient.getAphrodite());
        }
        catch (AphroditeException e) {
            logger.log(Level.SEVERE, "Can not get aphrodite due to : ", e);
        }
        PatchHomeService patchHomeService = new PatchHomeService();
        JiraIssueHomeImpl issueHomeService = new JiraIssueHomeImpl();
        ViolationHomeService violationHomeService = new ViolationHomeService();
        GithubPullRequestHomeService GithubPullRequestHomeService2 = new GithubPullRequestHomeService(aphrodite);
        simpleContainer.register(PatchHome.class.getSimpleName(), (Object)patchHomeService);
        simpleContainer.register(IssueHome.class.getSimpleName(), (Object)issueHomeService);
        simpleContainer.register(ViolationHome.class.getSimpleName(), (Object)violationHomeService);
        simpleContainer.register(PullRequestHome.class.getSimpleName(), (Object)GithubPullRequestHomeService2);
    }
}

