/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.config;

import java.util.Objects;
import org.jboss.set.aphrodite.config.AbstractServiceConfig;
import org.jboss.set.aphrodite.config.TrackerType;

public class IssueTrackerConfig
extends AbstractServiceConfig {
    private final TrackerType tracker;
    private final int defaultIssueLimit;

    public IssueTrackerConfig(String url, String username, String password, TrackerType tracker, int defaultIssueLimit) {
        super(url, username, password);
        Objects.requireNonNull(tracker, "The 'tracker' field must be set for all IssueTrackers");
        this.tracker = tracker;
        this.defaultIssueLimit = defaultIssueLimit;
    }

    public TrackerType getTracker() {
        return this.tracker;
    }

    public int getDefaultIssueLimit() {
        return this.defaultIssueLimit;
    }

    @Override
    public String toString() {
        return "IssueTrackerConfig{url='" + this.getUrl() + '\'' + ", username='" + this.getUsername() + '\'' + ", password='" + this.getPassword() + '\'' + ", tracker='" + (Object)((Object)this.tracker) + '\'' + ", defaultIssueLimit='" + this.defaultIssueLimit + '\'' + '}';
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.defaultIssueLimit;
        result = 31 * result + (this.tracker == null ? 0 : this.tracker.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IssueTrackerConfig other = (IssueTrackerConfig)obj;
        return this.defaultIssueLimit == other.defaultIssueLimit && this.tracker == other.tracker;
    }
}

