/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.domain;

import java.util.Objects;
import java.util.Optional;

public class Comment {
    private final String parentIssueId;
    private final String id;
    private final String body;
    private final boolean isPrivate;

    public Comment(String parentIssueId, String id, String body, boolean isPrivate) {
        Objects.requireNonNull(body, "A comment cannot have a null body.");
        this.parentIssueId = parentIssueId;
        this.id = id;
        this.body = body;
        this.isPrivate = isPrivate;
    }

    public Comment(String id, String body, boolean isPrivate) {
        this(null, id, body, isPrivate);
    }

    public Comment(String body, boolean isPrivate) {
        this(null, null, body, isPrivate);
    }

    public Optional<String> getParentIssueId() {
        return Optional.ofNullable(this.parentIssueId);
    }

    public Optional<String> getId() {
        return Optional.ofNullable(this.id);
    }

    public String getBody() {
        return this.body;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public String toString() {
        return "Comment{parentIssueId='" + this.parentIssueId + '\'' + ", id='" + this.id + '\'' + ", body='" + this.body + '\'' + ", isPrivate=" + this.isPrivate + '}';
    }
}

