/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.repository.services.common;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.jboss.set.aphrodite.common.Utils;
import org.jboss.set.aphrodite.config.AphroditeConfig;
import org.jboss.set.aphrodite.config.RepositoryConfig;
import org.jboss.set.aphrodite.domain.Issue;
import org.jboss.set.aphrodite.domain.Patch;
import org.jboss.set.aphrodite.domain.PatchState;
import org.jboss.set.aphrodite.domain.Repository;
import org.jboss.set.aphrodite.repository.services.common.RepositoryType;
import org.jboss.set.aphrodite.spi.NotFoundException;
import org.jboss.set.aphrodite.spi.RepositoryService;

public abstract class AbstractRepositoryService
implements RepositoryService {
    protected final RepositoryType REPOSITORY_TYPE;
    protected RepositoryConfig config;
    protected URL baseUrl;

    protected abstract Log getLog();

    public AbstractRepositoryService(RepositoryType REPOSITORY_TYPE) {
        this.REPOSITORY_TYPE = REPOSITORY_TYPE;
    }

    @Override
    public boolean init(AphroditeConfig aphroditeConfig) {
        Iterator<RepositoryConfig> i = aphroditeConfig.getRepositoryConfigs().iterator();
        while (i.hasNext()) {
            RepositoryConfig config = i.next();
            if (config.getType() != this.REPOSITORY_TYPE) continue;
            i.remove();
            return this.init(config);
        }
        return false;
    }

    @Override
    public boolean init(RepositoryConfig config) {
        this.config = config;
        String url = config.getUrl();
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        try {
            this.baseUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            String errorMsg = "Invalid Repository url. " + this.getClass().getName() + " service for '" + url + "' cannot be started";
            Utils.logException(this.getLog(), errorMsg, e);
            return false;
        }
        return true;
    }

    @Override
    public Repository getRepository(URL url) throws NotFoundException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public Patch getPatch(URL url) throws NotFoundException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public List<Patch> getPatchesAssociatedWith(Issue issue) throws NotFoundException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public List<Patch> getPatchesByState(Repository repository, PatchState state) throws NotFoundException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public void addCommentToPatch(Patch patch, String comment) throws NotFoundException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public boolean urlExists(URL url) {
        Objects.requireNonNull(url);
        return url.getHost().equals(this.baseUrl.getHost());
    }

    protected void checkHost(URL url) throws NotFoundException {
        if (!this.urlExists(url)) {
            throw new NotFoundException("The requested Repository cannot be found as it is not hosted on this server.");
        }
    }
}

