/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.repository.services.github;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Issue;
import org.eclipse.egit.github.core.Label;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.github.core.RepositoryBranch;
import org.eclipse.egit.github.core.RepositoryCommit;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.client.RequestException;
import org.eclipse.egit.github.core.service.CollaboratorService;
import org.eclipse.egit.github.core.service.CommitService;
import org.eclipse.egit.github.core.service.IssueService;
import org.eclipse.egit.github.core.service.LabelService;
import org.eclipse.egit.github.core.service.PullRequestService;
import org.eclipse.egit.github.core.service.RepositoryService;
import org.eclipse.egit.github.core.service.UserService;
import org.jboss.set.aphrodite.common.Utils;
import org.jboss.set.aphrodite.config.RepositoryConfig;
import org.jboss.set.aphrodite.domain.CommitStatus;
import org.jboss.set.aphrodite.domain.Patch;
import org.jboss.set.aphrodite.domain.PatchState;
import org.jboss.set.aphrodite.domain.Repository;
import org.jboss.set.aphrodite.repository.services.common.AbstractRepositoryService;
import org.jboss.set.aphrodite.repository.services.common.RepositoryType;
import org.jboss.set.aphrodite.repository.services.github.CustomGitHubClient;
import org.jboss.set.aphrodite.repository.services.github.GitHubGlobalSearchService;
import org.jboss.set.aphrodite.repository.services.github.GitHubWrapper;
import org.jboss.set.aphrodite.repository.services.github.SearchResult;
import org.jboss.set.aphrodite.spi.NotFoundException;

public class GitHubRepositoryService
extends AbstractRepositoryService {
    private static final Log LOG = LogFactory.getLog(org.jboss.set.aphrodite.spi.RepositoryService.class);
    private final GitHubWrapper WRAPPER = new GitHubWrapper();
    private CustomGitHubClient gitHubClient;
    private static final Pattern RELATED_PR_PATTERN = Pattern.compile(".*github\\.com.*?/([a-zA-Z_0-9-]*)/([a-zA-Z_0-9-]*)/pull.?/(\\d+)", 2);
    private static final Pattern ABBREVIATED_RELATED_PR_PATTERN = Pattern.compile("([a-zA-Z_0-9-//]*)#(\\d+)", 2);
    private static final Pattern ABBREVIATED_RELATED_PR_PATTERN_EXTERNAL_REPO = Pattern.compile("([a-zA-Z_0-9-]*)/([a-zA-Z_0-9-]*)#(\\d+)", 2);

    public GitHubRepositoryService() {
        super(RepositoryType.GITHUB);
    }

    @Override
    protected Log getLog() {
        return LOG;
    }

    @Override
    public boolean init(RepositoryConfig config) {
        boolean parentInitiated = super.init(config);
        if (!parentInitiated) {
            return false;
        }
        try {
            this.gitHubClient = CustomGitHubClient.createClient(this.baseUrl.toString());
            this.gitHubClient.setCredentials(config.getUsername(), config.getPassword());
            new UserService(this.gitHubClient).getUser();
        }
        catch (IOException e) {
            Utils.logException(LOG, "Authentication failed for RepositoryService: " + this.getClass().getName(), e);
            return false;
        }
        return true;
    }

    private Patch getPatch(String url) {
        try {
            return this.getPatch(new URL(url));
        }
        catch (MalformedURLException | NotFoundException e) {
            return null;
        }
    }

    @Override
    public Patch getPatch(URL url) throws NotFoundException {
        this.checkHost(url);
        String[] elements = url.getPath().split("/");
        int pullId = Integer.parseInt(elements[elements.length - 1]);
        RepositoryId repositoryId = RepositoryId.createFromUrl(url);
        PullRequestService pullRequestService = new PullRequestService(this.gitHubClient);
        try {
            PullRequest pullRequest = pullRequestService.getPullRequest(repositoryId, pullId);
            return this.WRAPPER.pullRequestToPatch(pullRequest);
        }
        catch (IOException e) {
            Utils.logException(LOG, e);
            throw new NotFoundException(e);
        }
    }

    @Override
    public Repository getRepository(URL url) throws NotFoundException {
        this.checkHost(url);
        RepositoryId id = RepositoryId.createFromUrl(url);
        RepositoryService rs = new RepositoryService(this.gitHubClient);
        try {
            List<RepositoryBranch> branches = rs.getBranches(id);
            return this.WRAPPER.toAphroditeRepository(url, branches);
        }
        catch (IOException e) {
            Utils.logException(LOG, e);
            throw new NotFoundException(e);
        }
    }

    @Override
    public List<Patch> getPatchesAssociatedWith(org.jboss.set.aphrodite.domain.Issue issue) throws NotFoundException {
        String trackerId = issue.getTrackerId().orElseThrow(() -> new IllegalArgumentException("Issue.trackerId must be set."));
        try {
            GitHubGlobalSearchService searchService = new GitHubGlobalSearchService(this.gitHubClient);
            List<SearchResult> searchResults = searchService.searchAllPullRequests(trackerId);
            return searchResults.stream().map(pr -> this.getPatch(pr.getUrl())).filter(patch -> patch != null).collect(Collectors.toList());
        }
        catch (IOException e) {
            Utils.logException(LOG, e);
            throw new NotFoundException(e);
        }
    }

    @Override
    public List<Patch> getPatchesByState(Repository repository, PatchState state) throws NotFoundException {
        URL url = repository.getURL();
        this.checkHost(url);
        RepositoryId id = RepositoryId.createFromUrl(url);
        PullRequestService pullRequestService = new PullRequestService(this.gitHubClient);
        try {
            String githubState = state.toString().toLowerCase();
            List<PullRequest> pullRequests = pullRequestService.getPullRequests(id, githubState);
            return this.WRAPPER.toAphroditePatches(pullRequests);
        }
        catch (IOException e) {
            Utils.logException(LOG, e);
            throw new NotFoundException(e);
        }
    }

    @Override
    public void addCommentToPatch(Patch patch, String comment) throws NotFoundException {
        URL url = patch.getURL();
        this.checkHost(url);
        int pullId = Integer.parseInt(patch.getId());
        RepositoryId id = RepositoryId.createFromUrl(url);
        try {
            IssueService is = new IssueService(this.gitHubClient);
            is.createComment((IRepositoryIdProvider)id, pullId, comment);
        }
        catch (IOException e) {
            Utils.logException(LOG, e);
            throw new NotFoundException(e);
        }
    }

    @Override
    public boolean hasModifiableLabels(Repository repository) throws NotFoundException {
        URL url = repository.getURL();
        this.checkHost(url);
        RepositoryId id = RepositoryId.createFromUrl(url);
        try {
            return new CollaboratorService(this.gitHubClient).isCollaborator(id, this.gitHubClient.getUser());
        }
        catch (IOException e) {
            if (e instanceof RequestException && ((RequestException)e).getStatus() == 403) {
                return false;
            }
            Utils.logException(LOG, e);
            throw new NotFoundException(e);
        }
    }

    @Override
    public void addLabelToPatch(Patch patch, String labelName) throws NotFoundException {
        URL url = patch.getURL();
        this.checkHost(url);
        int patchId = new Integer(Utils.getTrailingValueFromUrlPath(url));
        RepositoryId repositoryId = RepositoryId.createFromUrl(url);
        IssueService issueService = new IssueService(this.gitHubClient);
        try {
            Label newLabel = this.getLabel(repositoryId, labelName);
            Issue issue = issueService.getIssue((IRepositoryIdProvider)repositoryId, patchId);
            List<Label> issueLabels = issue.getLabels();
            if (issueLabels.contains(newLabel)) {
                return;
            }
            issueLabels.add(newLabel);
            issue.setLabels(issueLabels);
            issueService.editIssue(repositoryId, issue);
        }
        catch (IOException e) {
            Utils.logException(LOG, e);
            throw new NotFoundException(e);
        }
    }

    private Label getLabel(RepositoryId repositoryId, String labelName) throws NotFoundException, IOException {
        LabelService labelService = new LabelService(this.gitHubClient);
        List<Label> labels = labelService.getLabels(repositoryId);
        return this.getLabel(repositoryId, labelName, labels);
    }

    private Label getLabel(RepositoryId repositoryId, String labelName, List<Label> validLabels) throws NotFoundException {
        for (Label label : validLabels) {
            if (!label.getName().equalsIgnoreCase(labelName)) continue;
            return label;
        }
        throw new NotFoundException("No label exists with the name '" + labelName + "' at repository '" + repositoryId.getName() + "'");
    }

    @Override
    public List<org.jboss.set.aphrodite.domain.Label> getLabelsFromRepository(Repository repository) throws NotFoundException {
        List<Label> labels;
        URL url = repository.getURL();
        this.checkHost(url);
        RepositoryId repositoryId = RepositoryId.createFromUrl(url);
        LabelService labelService = new LabelService(this.gitHubClient);
        try {
            labels = labelService.getLabels(repositoryId);
        }
        catch (IOException e) {
            Utils.logException(LOG, e);
            throw new NotFoundException(e);
        }
        return this.WRAPPER.pullRequestLabeltoPatchLabel(labels);
    }

    @Override
    public List<org.jboss.set.aphrodite.domain.Label> getLabelsFromPatch(Patch patch) throws NotFoundException {
        URL url = patch.getURL();
        this.checkHost(url);
        String patchId = patch.getId();
        RepositoryId repositoryId = RepositoryId.createFromUrl(url);
        IssueService issueService = new IssueService(this.gitHubClient);
        try {
            Issue issue = issueService.getIssue((IRepositoryIdProvider)repositoryId, patchId);
            return this.WRAPPER.pullRequestLabeltoPatchLabel(issue.getLabels());
        }
        catch (IOException e) {
            Utils.logException(LOG, e);
            throw new NotFoundException(e);
        }
    }

    @Override
    public void setLabelsToPatch(Patch patch, List<org.jboss.set.aphrodite.domain.Label> labels) throws NotFoundException {
        URL url = patch.getURL();
        this.checkHost(url);
        int patchId = new Integer(Utils.getTrailingValueFromUrlPath(url));
        RepositoryId repositoryId = RepositoryId.createFromUrl(url);
        LabelService labelService = new LabelService(this.gitHubClient);
        try {
            ArrayList<Label> issueLabels = new ArrayList<Label>();
            List<Label> existingLabels = labelService.getLabels(repositoryId);
            for (org.jboss.set.aphrodite.domain.Label label : labels) {
                issueLabels.add(this.getLabel(repositoryId, label.getName(), existingLabels));
            }
            issueLabels.add(existingLabels.get(0));
            labelService.setLabels(repositoryId, Long.toString(patchId), issueLabels);
        }
        catch (IOException e) {
            Utils.logException(LOG, e);
            throw new NotFoundException(e);
        }
    }

    @Override
    public void removeLabelFromPatch(Patch patch, String name) throws NotFoundException {
        URL url = patch.getURL();
        this.checkHost(url);
        IssueService issueService = new IssueService(this.gitHubClient);
        RepositoryId repositoryId = RepositoryId.createFromUrl(url);
        try {
            List<Label> labels = issueService.getIssue((IRepositoryIdProvider)repositoryId, patch.getId()).getLabels();
            for (Label label : labels) {
                if (!label.getName().equalsIgnoreCase(name)) continue;
                this.deleteLabelWithEscapedName(repositoryId, patch, label);
                return;
            }
        }
        catch (IOException e) {
            Utils.logException(LOG, e);
            throw new NotFoundException(e);
        }
        throw new NotFoundException("No label exists with the name '" + name + "' at repository '" + repositoryId + "'");
    }

    private void deleteLabelWithEscapedName(RepositoryId repositoryId, Patch patch, Label label) throws IOException {
        String path = "/repos/" + repositoryId.generateId() + "/issues/" + patch.getId() + "/labels/" + label.getName();
        try {
            URI uri = new URI(this.baseUrl.getProtocol(), this.baseUrl.getHost(), path, null);
            path = uri.toASCIIString().substring(this.baseUrl.toString().length() - 1);
            this.gitHubClient.deleteWith200Response(path);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public List<Patch> findPatchesRelatedTo(Patch patch) {
        try {
            List<URL> urls = this.getPRFromDescription(patch.getURL(), patch.getBody());
            ArrayList<Patch> related = new ArrayList<Patch>();
            for (URL url : urls) {
                try {
                    if (this.urlExists(url)) {
                        related.add(this.getPatch(url));
                        continue;
                    }
                    Utils.logWarnMessage(LOG, "Unable to process url '" + url + "' as it is not located on this service");
                }
                catch (NotFoundException e) {
                    Utils.logException(LOG, "Unable to retrieve url '" + url + "' referenced in the patch at: " + patch.getURL(), e);
                }
            }
            return related;
        }
        catch (MalformedURLException | URISyntaxException e) {
            Utils.logException(LOG, "something went wrong while trying to get related patches to " + patch.getURL(), e);
            return Collections.emptyList();
        }
    }

    private List<URL> getPRFromDescription(URL url, String content) throws MalformedURLException, URISyntaxException {
        String[] paths = url.getPath().split("/");
        Matcher matcher = RELATED_PR_PATTERN.matcher(content);
        ArrayList<URL> relatedPullRequests = new ArrayList<URL>();
        while (matcher.find()) {
            if (matcher.groupCount() != 3) continue;
            URL relatedPullRequest = new URI("https://github.com/" + matcher.group(1) + "/" + matcher.group(2) + "/pulls/" + matcher.group(3)).toURL();
            relatedPullRequests.add(relatedPullRequest);
        }
        Matcher abbreviatedMatcher = ABBREVIATED_RELATED_PR_PATTERN.matcher(content);
        while (abbreviatedMatcher.find()) {
            URL relatedPullRequest;
            String match = abbreviatedMatcher.group();
            Matcher abbreviatedExternalMatcher = ABBREVIATED_RELATED_PR_PATTERN_EXTERNAL_REPO.matcher(match);
            if (abbreviatedExternalMatcher.find() && abbreviatedExternalMatcher.groupCount() == 3) {
                relatedPullRequest = new URI("https://github.com/" + abbreviatedExternalMatcher.group(1) + "/" + abbreviatedExternalMatcher.group(2) + "/pulls/" + abbreviatedExternalMatcher.group(3)).toURL();
                relatedPullRequests.add(relatedPullRequest);
                continue;
            }
            if (abbreviatedMatcher.groupCount() != 2) continue;
            relatedPullRequest = new URI("https://github.com/" + paths[1] + "/" + paths[2] + "/" + "/pulls/" + abbreviatedMatcher.group(2)).toURL();
            relatedPullRequests.add(relatedPullRequest);
        }
        return relatedPullRequests;
    }

    @Override
    public CommitStatus getCommitStatusFromPatch(Patch patch) throws NotFoundException {
        URL url = patch.getURL();
        this.checkHost(url);
        PullRequestService pullrequestService = new PullRequestService(this.gitHubClient);
        CommitService commitService = new CommitService(this.gitHubClient);
        CommitStatus status = null;
        int patchId = Integer.parseInt(patch.getId());
        RepositoryId repositoryId = RepositoryId.createFromUrl(url);
        try {
            List<org.eclipse.egit.github.core.CommitStatus> statuses;
            String sha = null;
            List<RepositoryCommit> commits = pullrequestService.getCommits(repositoryId, patchId);
            if (commits.size() > 0) {
                sha = commits.get(commits.size() - 1).getSha();
            }
            if ((statuses = commitService.getStatuses(repositoryId, sha)).size() > 0) {
                String sta = this.getCombineStatus(statuses);
                status = CommitStatus.fromString(sta);
            }
        }
        catch (IOException e) {
            Utils.logException(LOG, e);
            throw new NotFoundException(e);
        }
        if (status != null) {
            return status;
        }
        return CommitStatus.UNKNOWN;
    }

    private String getCombineStatus(List<org.eclipse.egit.github.core.CommitStatus> comStatuses) {
        int count = 0;
        boolean flag = false;
        ArrayList<String> stas = new ArrayList<String>();
        for (org.eclipse.egit.github.core.CommitStatus status : comStatuses) {
            String sta = status.getState();
            stas.add(sta);
            if (!sta.equals("pending")) {
                if (sta.equals("failure")) {
                    return "failure";
                }
                if (sta.equals("error")) {
                    return "error";
                }
            } else {
                flag = true;
                String description = status.getDescription();
                if (description != null && description.contains("Travis")) {
                    return stas.contains("success") ? "success" : "pending";
                }
                if (comStatuses.size() > 2 * count) {
                    String temp = comStatuses.get(2 * count).getState();
                    return temp.equals("pending") ? "pending" : "success";
                }
                if (comStatuses.size() == 2 * count) {
                    return "success";
                }
            }
            ++count;
        }
        return !flag ? "success" : null;
    }

    @Override
    public boolean repositoryAccessable(URL url) {
        if (url.toString().contains("svn.jboss.org")) {
            Utils.logWarnMessage(LOG, "svn repository : " + url + " is not supported.");
            return false;
        }
        RepositoryId id = RepositoryId.createFromUrl(url);
        RepositoryService rs = new RepositoryService(this.gitHubClient);
        try {
            rs.getBranches(id);
        }
        catch (IOException e) {
            Utils.logWarnMessage(LOG, "repository : " + url + " is not accessable due to " + e.getMessage() + ". Check repository link and your account permission.");
            return false;
        }
        return true;
    }
}

