/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.assistant;

import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Util {
    public static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static Map<String, String> map(String ... args) {
        if (args == null || args.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        while (i < args.length) {
            map.put(args[i++], args[i++]);
        }
        return map;
    }

    public static Properties loadProperties(String configurationFileProperty, String configurationFileDefault) throws IOException {
        String propsFileUserPath = System.getProperty(configurationFileProperty, configurationFileDefault);
        Properties props = new Properties();
        props.load(new FileReader(new File(propsFileUserPath)));
        return props;
    }

    public static String require(Properties props, String name) {
        String ret = (String)props.get(name);
        if (ret == null) {
            throw new RuntimeException(name + " must be specified in processor.properties");
        }
        return ret.trim();
    }

    public static String get(Properties props, String name) {
        return (String)props.get(name);
    }

    public static String get(Properties props, String name, String defaultValue) {
        String value = (String)props.get(name);
        return value == null ? defaultValue : value;
    }

    public static String getTime() {
        Date date = new Date();
        return Util.getTime(date);
    }

    public static String getTime(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return dateFormat.format(date);
    }
}

