/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.util;

import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.model.Location;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocationUtils {
    private static final Logger logger = LoggerFactory.getLogger(LocationUtils.class);

    private LocationUtils() {
    }

    public static int getTimeoutSeconds(ConcreteResource resource) {
        logger.debug("Retrieving timeout from resource: {}", (Object)resource);
        return LocationUtils.getTimeoutSeconds(resource.getLocation());
    }

    public static int getTimeoutSeconds(Location location) {
        if (logger.isDebugEnabled()) {
            logger.debug("Retrieving timeout from location: {}", (Object)location);
        }
        return location.getAttribute("connection-timeout", Integer.class, 30);
    }

    public static Integer getMaxConnections(Location location) {
        return location.getAttribute("max-connections", Integer.class, 10);
    }

    public static int getMetadataTimeoutSeconds(Location location) {
        return location.getAttribute("metadata-timeout", Integer.class, 86400);
    }
}

