/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.util.Date;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.PagedIterator;
import org.kohsuke.github.Requester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GHCommitQueryBuilder {
    private final Requester req;
    private final GHRepository repo;

    GHCommitQueryBuilder(GHRepository repo) {
        this.repo = repo;
        this.req = repo.root.retrieve();
    }

    public GHCommitQueryBuilder author(String author) {
        this.req.with("author", author);
        return this;
    }

    public GHCommitQueryBuilder path(String path) {
        this.req.with("path", path);
        return this;
    }

    public GHCommitQueryBuilder from(String ref) {
        this.req.with("sha", ref);
        return this;
    }

    public GHCommitQueryBuilder pageSize(int pageSize) {
        this.req.with("per_page", pageSize);
        return this;
    }

    public GHCommitQueryBuilder since(Date dt) {
        this.req.with("since", GitHub.printDate(dt));
        return this;
    }

    public GHCommitQueryBuilder since(long timestamp) {
        return this.since(new Date(timestamp));
    }

    public GHCommitQueryBuilder until(Date dt) {
        this.req.with("until", GitHub.printDate(dt));
        return this;
    }

    public GHCommitQueryBuilder until(long timestamp) {
        return this.until(new Date(timestamp));
    }

    public PagedIterable<GHCommit> list() {
        return new PagedIterable<GHCommit>(){

            @Override
            public PagedIterator<GHCommit> _iterator(int pageSize) {
                return new PagedIterator<GHCommit>(GHCommitQueryBuilder.this.req.asIterator(GHCommitQueryBuilder.this.repo.getApiTailUrl("commits"), GHCommit[].class, pageSize)){

                    protected void wrapUp(GHCommit[] page) {
                        for (GHCommit c : page) {
                            c.wrapUp(GHCommitQueryBuilder.this.repo);
                        }
                    }
                };
            }
        };
    }
}

