/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.cdi.util.weft;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import org.commonjava.cdi.util.weft.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextSensitiveWeakHashMap<K, V>
extends WeakHashMap<K, V> {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String uniqueId = UUID.randomUUID().toString();
    private final Consumer<ThreadContext> finalizer = ctx -> {
        this.logger.trace("Finalizer called for {}", (Object)this.uniqueId);
        ctx.remove(this.uniqueId);
    };

    @Override
    public V put(K k, V v) {
        V ret = super.put(k, v);
        ThreadContext ctx = ThreadContext.getContext(false);
        if (ctx != null) {
            Object obj = ctx.computeIfAbsent(this.uniqueId, (? super String o) -> new HashSet());
            Set keys = (Set)obj;
            this.logger.trace("Add key {} for {}", (Object)k, (Object)this.uniqueId);
            keys.add(k);
            ctx.registerFinalizer(this.finalizer);
        }
        return ret;
    }

    @Override
    public String toString() {
        return "ContextSensitiveWeakHashMap{uniqueId='" + this.uniqueId + '\'' + '}';
    }

    public static <K, V> Map<K, V> newSynchronizedContextSensitiveWeakHashMap() {
        return Collections.synchronizedMap(new ContextSensitiveWeakHashMap<K, V>());
    }
}

