/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.atlas.ident;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public enum DependencyScope {
    _import("import", new DependencyScope[0]),
    toolchain(new DependencyScope[0]),
    provided(new DependencyScope[0]),
    embedded(new DependencyScope[0]),
    compile(provided, embedded),
    runtime(compile),
    system(new DependencyScope[0]),
    test(provided, embedded, compile, runtime, system);

    private final Set<DependencyScope> implied;
    private String realName;

    private DependencyScope(String realName, DependencyScope ... implied) {
        this.realName = realName;
        this.implied = new HashSet<DependencyScope>(Arrays.asList(implied));
    }

    private DependencyScope(DependencyScope ... implied) {
        this.realName = this.name();
        this.implied = new HashSet<DependencyScope>(Arrays.asList(implied));
    }

    public boolean implies(DependencyScope scope) {
        return scope == this || this.implied.contains((Object)scope);
    }

    public String realName() {
        return this.realName;
    }

    public static DependencyScope getScope(String scope) {
        if (scope == null) {
            return null;
        }
        scope = scope.trim().toLowerCase();
        for (DependencyScope ds : DependencyScope.values()) {
            if (!ds.realName.equals(scope)) continue;
            return ds;
        }
        return null;
    }

    public static DependencyScope[] parseScopes(String scopesStr) {
        String[] rawScopes = scopesStr.split("\\s*[+,|]+\\s*");
        ArrayList<DependencyScope> result = new ArrayList<DependencyScope>(rawScopes.length);
        for (String rawScope : rawScopes) {
            DependencyScope scope;
            if (rawScope == null || rawScope.trim().length() < 1 || (scope = DependencyScope.getScope(rawScope)) == null || result.contains((Object)scope)) continue;
            result.add(scope);
        }
        return result.toArray(new DependencyScope[result.size()]);
    }
}

