/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.common.util;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.ManipulationUncheckedException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.session.MavenSessionHandler;
import org.commonjava.maven.ext.common.util.ProfileUtils;
import org.commonjava.maven.ext.common.util.PropertyInterpolator;

public final class PropertyResolver {
    private PropertyResolver() {
    }

    public static String resolveInheritedProperties(MavenSessionHandler session, Project start, String value) throws ManipulationException {
        return PropertyResolver.resolveProperties(session, start.getInheritedList(), value);
    }

    private static Properties searchProfiles(MavenSessionHandler session, Project p) {
        Properties result = new Properties();
        ProfileUtils.getProfiles(session, p.getModel()).forEach(pr -> result.putAll((Map<?, ?>)pr.getProperties()));
        return result;
    }

    public static String resolvePropertiesUnchecked(MavenSessionHandler session, List<Project> projects, String value) {
        try {
            return PropertyResolver.resolveProperties(session, projects, value);
        }
        catch (ManipulationException e) {
            throw new ManipulationUncheckedException(e);
        }
    }

    public static String resolveProperties(MavenSessionHandler session, List<Project> projects, String value) throws ManipulationException {
        Properties amalgamated = new Properties();
        for (Project p : projects) {
            amalgamated.putAll((Map<?, ?>)p.getModel().getProperties());
            amalgamated.putAll((Map<?, ?>)PropertyResolver.searchProfiles(session, p));
        }
        PropertyInterpolator pi = new PropertyInterpolator(amalgamated, projects.get(0));
        return pi.interp(value);
    }
}

