/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.io;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Writer;
import org.commonjava.maven.ext.common.ManipulationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class SettingsIO {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SettingsBuilder settingsBuilder;

    @Inject
    public SettingsIO(SettingsBuilder settingsBuilder) {
        this.settingsBuilder = settingsBuilder;
    }

    public void write(Settings settings, File settingsFile) throws ManipulationException {
        try {
            PrintWriter printWriter = new PrintWriter(settingsFile, "UTF-8");
            new SettingsXpp3Writer().write(printWriter, settings);
        }
        catch (IOException e) {
            throw new ManipulationException("Failed to create repo removal backup settings.xml file.", (Throwable)e, settingsFile, e.getMessage());
        }
    }

    public void update(Settings settings, File settingsFile) throws ManipulationException {
        try {
            Iterator<Object> i;
            Settings defaultSettings = new Settings();
            if (settingsFile.exists()) {
                DefaultSettingsBuildingRequest settingsRequest = new DefaultSettingsBuildingRequest();
                settingsRequest.setGlobalSettingsFile(settingsFile);
                defaultSettings = this.settingsBuilder.build(settingsRequest).getEffectiveSettings();
            }
            for (Profile profile : settings.getProfiles()) {
                i = defaultSettings.getProfiles().iterator();
                while (i.hasNext()) {
                    if (!i.next().getId().equals(profile.getId())) continue;
                    i.remove();
                }
                defaultSettings.addProfile(profile);
            }
            for (String activeProfile : settings.getActiveProfiles()) {
                i = defaultSettings.getActiveProfiles().iterator();
                while (i.hasNext()) {
                    if (!((String)i.next()).equals(activeProfile)) continue;
                    i.remove();
                }
                defaultSettings.addActiveProfile(activeProfile);
            }
            for (Mirror mirror : settings.getMirrors()) {
                defaultSettings.addMirror(mirror);
            }
            for (Proxy proxy : settings.getProxies()) {
                defaultSettings.addProxy(proxy);
            }
            for (Server server : settings.getServers()) {
                defaultSettings.addServer(server);
            }
            for (String pluginGroup : settings.getPluginGroups()) {
                defaultSettings.addPluginGroup(pluginGroup);
            }
            if (settings.getLocalRepository() != null) {
                defaultSettings.setLocalRepository(settings.getLocalRepository());
            }
            this.write(defaultSettings, settingsFile);
        }
        catch (SettingsBuildingException e) {
            throw new ManipulationException("Failed to build existing settings.xml for repo removal backup.", (Throwable)e, settingsFile, e.getMessage());
        }
    }
}

