/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.Alternative;
import javax.inject.Named;
import org.commonjava.maven.galley.event.EventMetadata;
import org.commonjava.maven.galley.io.AbstractTransferDecorator;
import org.commonjava.maven.galley.io.DeprecatedChecksummingFilter;
import org.commonjava.maven.galley.io.checksum.AbstractChecksumGenerator;
import org.commonjava.maven.galley.io.checksum.AbstractChecksumGeneratorFactory;
import org.commonjava.maven.galley.io.checksum.ChecksummingDecoratorAdvisor;
import org.commonjava.maven.galley.io.checksum.ChecksummingInputStream;
import org.commonjava.maven.galley.io.checksum.ChecksummingOutputStream;
import org.commonjava.maven.galley.io.checksum.TransferMetadataConsumer;
import org.commonjava.maven.galley.model.SpecialPathInfo;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.model.TransferOperation;
import org.commonjava.maven.galley.spi.io.SpecialPathManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alternative
@Named
public final class ChecksummingTransferDecorator
extends AbstractTransferDecorator {
    public static final String FORCE_CHECKSUM = "force-checksum";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ChecksummingDecoratorAdvisor writerFilter;
    private final ChecksummingDecoratorAdvisor readerFilter;
    private final TransferMetadataConsumer consumer;
    private final Set<AbstractChecksumGeneratorFactory<?>> checksumFactories;
    private SpecialPathManager specialPathManager;

    public ChecksummingTransferDecorator(ChecksummingDecoratorAdvisor readerFilter, ChecksummingDecoratorAdvisor writerFilter, SpecialPathManager specialPathManager, TransferMetadataConsumer consumer, Set<AbstractChecksumGeneratorFactory<?>> checksumFactories) {
        this.readerFilter = readerFilter;
        this.writerFilter = writerFilter;
        this.specialPathManager = specialPathManager;
        this.consumer = consumer;
        this.checksumFactories = checksumFactories;
    }

    public ChecksummingTransferDecorator(ChecksummingDecoratorAdvisor readerFilter, ChecksummingDecoratorAdvisor writerFilter, SpecialPathManager specialPathManager, TransferMetadataConsumer consumer, AbstractChecksumGeneratorFactory<?> ... checksumFactories) {
        this(readerFilter, writerFilter, specialPathManager, consumer, new HashSet(Arrays.asList(checksumFactories)));
    }

    @Deprecated
    public ChecksummingTransferDecorator(Set<TransferOperation> writeChecksumFilesOn, SpecialPathManager specialPathManager, boolean checksumReaders, boolean checksumWriters, TransferMetadataConsumer consumer, AbstractChecksumGeneratorFactory<?> ... checksumFactories) {
        this((ChecksummingDecoratorAdvisor)new DeprecatedChecksummingFilter(checksumReaders, DeprecatedChecksummingFilter.calculateWriteOperations(writeChecksumFilesOn, TransferOperation.DOWNLOAD)), (ChecksummingDecoratorAdvisor)new DeprecatedChecksummingFilter(checksumWriters, writeChecksumFilesOn), specialPathManager, consumer, new HashSet(Arrays.asList(checksumFactories)));
    }

    @Deprecated
    public ChecksummingTransferDecorator(Set<TransferOperation> writeChecksumFilesOn, SpecialPathManager specialPathManager, boolean checksumReaders, boolean checksumWriters, TransferMetadataConsumer consumer, Collection<AbstractChecksumGeneratorFactory<?>> checksumFactories) {
        this((ChecksummingDecoratorAdvisor)new DeprecatedChecksummingFilter(checksumReaders, DeprecatedChecksummingFilter.calculateWriteOperations(writeChecksumFilesOn, TransferOperation.DOWNLOAD)), (ChecksummingDecoratorAdvisor)new DeprecatedChecksummingFilter(checksumWriters, writeChecksumFilesOn), specialPathManager, consumer, ChecksummingTransferDecorator.toSet(checksumFactories));
    }

    private static Set<AbstractChecksumGeneratorFactory<?>> toSet(Collection<AbstractChecksumGeneratorFactory<?>> checksumFactories) {
        HashSet result = checksumFactories instanceof Set ? (HashSet)checksumFactories : new HashSet(checksumFactories);
        return result;
    }

    @Override
    public OutputStream decorateWrite(OutputStream stream, Transfer transfer, TransferOperation op, EventMetadata eventMetadata) throws IOException {
        Object forceObj = eventMetadata.get(FORCE_CHECKSUM);
        boolean force = Boolean.TRUE.equals(forceObj) || Boolean.parseBoolean(String.valueOf(forceObj));
        SpecialPathInfo specialPathInfo = this.specialPathManager.getSpecialPathInfo(transfer, eventMetadata.getPackageType());
        this.logger.trace("SpecialPathInfo for: {} is: {} (decoratable? {})", transfer, specialPathInfo, specialPathInfo == null || specialPathInfo.isDecoratable());
        if (force || specialPathInfo == null || specialPathInfo.isDecoratable()) {
            ChecksummingDecoratorAdvisor.ChecksumAdvice advice = this.writerFilter.getDecorationAdvice(transfer, op, eventMetadata);
            if (force && advice == ChecksummingDecoratorAdvisor.ChecksumAdvice.NO_DECORATE) {
                advice = ChecksummingDecoratorAdvisor.ChecksumAdvice.CALCULATE_NO_WRITE;
            }
            boolean consumerNeedsIt = this.consumer == null || this.consumer.needsMetadataFor(transfer);
            this.logger.trace("Advice is: {} for {} of: {} (and consumer is missing or needs it? {})", new Object[]{advice, op, transfer, consumerNeedsIt});
            if (advice != ChecksummingDecoratorAdvisor.ChecksumAdvice.NO_DECORATE && (this.consumer == null || this.consumer.needsMetadataFor(transfer))) {
                this.logger.trace("Wrapping output stream to: {} for checksum generation.", (Object)transfer);
                return new ChecksummingOutputStream(this.checksumFactories, stream, transfer, this.consumer, advice == ChecksummingDecoratorAdvisor.ChecksumAdvice.CALCULATE_AND_WRITE);
            }
        }
        this.logger.trace("NOT decorating write with ChecksummingTransferDecorator for: {}", (Object)transfer);
        return stream;
    }

    @Override
    public InputStream decorateRead(InputStream stream, Transfer transfer, EventMetadata eventMetadata) throws IOException {
        Object forceObj = eventMetadata.get(FORCE_CHECKSUM);
        boolean force = Boolean.TRUE.equals(forceObj) || Boolean.parseBoolean(String.valueOf(forceObj));
        SpecialPathInfo specialPathInfo = this.specialPathManager.getSpecialPathInfo(transfer, eventMetadata.getPackageType());
        this.logger.trace("SpecialPathInfo for: {} is: {} (decoratable? {})", transfer, specialPathInfo, specialPathInfo == null || specialPathInfo.isDecoratable());
        if (force || specialPathInfo == null || specialPathInfo.isDecoratable()) {
            ChecksummingDecoratorAdvisor.ChecksumAdvice advice = this.readerFilter.getDecorationAdvice(transfer, TransferOperation.DOWNLOAD, eventMetadata);
            if (force && advice == ChecksummingDecoratorAdvisor.ChecksumAdvice.NO_DECORATE) {
                advice = ChecksummingDecoratorAdvisor.ChecksumAdvice.CALCULATE_NO_WRITE;
            }
            boolean consumerNeedsIt = this.consumer == null || this.consumer.needsMetadataFor(transfer);
            this.logger.trace("Advice is: {} for {} of: {} (and consumer is missing or needs it? {})", new Object[]{advice, TransferOperation.DOWNLOAD, transfer, consumerNeedsIt});
            if (advice != ChecksummingDecoratorAdvisor.ChecksumAdvice.NO_DECORATE && (this.consumer == null || this.consumer.needsMetadataFor(transfer))) {
                return new ChecksummingInputStream(this.checksumFactories, stream, transfer, this.consumer, advice == ChecksummingDecoratorAdvisor.ChecksumAdvice.CALCULATE_AND_WRITE);
            }
        }
        this.logger.trace("NOT decorating read with ChecksummingTransferDecorator for: {}", (Object)transfer);
        return stream;
    }

    @Override
    public void decorateDelete(Transfer transfer, EventMetadata eventMetadata) throws IOException {
        if (transfer.isDirectory()) {
            return;
        }
        SpecialPathInfo specialPathInfo = this.specialPathManager.getSpecialPathInfo(transfer, eventMetadata.getPackageType());
        if (specialPathInfo == null || specialPathInfo.isDeletable()) {
            for (AbstractChecksumGeneratorFactory<?> factory : this.checksumFactories) {
                Object generator = factory.createGenerator(transfer);
                ((AbstractChecksumGenerator)generator).delete();
            }
        }
        if (this.consumer != null) {
            this.consumer.removeMetadata(transfer);
        }
    }
}

