/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.maven.model.view;

import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectRef;
import org.commonjava.maven.galley.maven.GalleyMavenException;
import org.commonjava.maven.galley.maven.model.view.MavenPomElementView;
import org.commonjava.maven.galley.maven.model.view.MavenPomView;
import org.commonjava.maven.galley.maven.model.view.OriginInfo;
import org.commonjava.maven.galley.maven.model.view.ProjectRefView;
import org.w3c.dom.Element;

public class MavenGAView
extends MavenPomElementView
implements ProjectRefView {
    private String groupId;
    private String artifactId;

    public MavenGAView(MavenPomView pomView, Element element, OriginInfo originInfo, String managementXpathFragment) {
        super(pomView, element, originInfo, managementXpathFragment);
    }

    public MavenGAView(MavenPomView pomView, Element element, OriginInfo originInfo) {
        super(pomView, element, originInfo, null);
    }

    @Override
    public synchronized String getGroupId() {
        if (this.groupId == null) {
            this.groupId = this.getValue("groupId");
        }
        return this.groupId;
    }

    protected void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Override
    public synchronized String getArtifactId() {
        if (this.artifactId == null) {
            this.artifactId = this.getValue("artifactId");
        }
        return this.artifactId;
    }

    @Override
    public ProjectRef asProjectRef() throws GalleyMavenException {
        try {
            return new SimpleProjectRef(this.getGroupId(), this.getArtifactId());
        }
        catch (IllegalArgumentException e) {
            throw new GalleyMavenException("Cannot render ProjectRef: {}:{}. Reason: {}", (Throwable)e, this.getGroupId(), this.getArtifactId(), e.getMessage());
        }
    }

    public String toString() {
        return String.format("%s [%s:%s]", this.getClass().getSimpleName(), this.getGroupId(), this.getArtifactId());
    }

    public boolean isValid() {
        return !this.containsExpression(this.getGroupId()) && !this.containsExpression(this.getArtifactId());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        String artifactId = this.getArtifactId();
        String groupId = this.getGroupId();
        result = 31 * result + (artifactId == null ? 0 : artifactId.hashCode());
        result = 31 * result + (groupId == null ? 0 : groupId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        String artifactId = this.getArtifactId();
        String groupId = this.getGroupId();
        MavenGAView other = (MavenGAView)obj;
        String oArtifactId = other.getArtifactId();
        String oGroupId = other.getGroupId();
        if (artifactId == null ? oArtifactId != null : !artifactId.equals(oArtifactId)) {
            return false;
        }
        if (groupId == null) {
            return oGroupId == null;
        }
        return groupId.equals(oGroupId);
    }
}

