/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.ext;

import java.util.Arrays;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.rest.client.ext.ClientHeadersFactory;

public class DefaultClientHeadersFactoryImpl
implements ClientHeadersFactory {
    public static final String PROPAGATE_PROPERTY = "org.eclipse.microprofile.rest.client.propagateHeaders";
    private static final String CLASS_NAME = DefaultClientHeadersFactoryImpl.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);

    private static Optional<Config> config() {
        try {
            return Optional.ofNullable(ConfigProvider.getConfig());
        }
        catch (ExceptionInInitializerError | IllegalStateException | NoClassDefFoundError ex) {
            return Optional.empty();
        }
    }

    private static Optional<String> getHeadersProperty() {
        Optional<Config> c = DefaultClientHeadersFactoryImpl.config();
        if (c.isPresent()) {
            return Optional.ofNullable(c.get().getOptionalValue(PROPAGATE_PROPERTY, String.class).orElse(null));
        }
        return Optional.empty();
    }

    @Override
    public MultivaluedMap<String, String> update(MultivaluedMap<String, String> incomingHeaders, MultivaluedMap<String, String> clientOutgoingHeaders) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.entering(CLASS_NAME, "update", new Object[]{incomingHeaders, clientOutgoingHeaders});
        }
        MultivaluedHashMap<String, String> propagatedHeaders = new MultivaluedHashMap<String, String>();
        Optional<String> propagateHeaderString = DefaultClientHeadersFactoryImpl.getHeadersProperty();
        if (propagateHeaderString.isPresent()) {
            Arrays.stream(propagateHeaderString.get().split(",")).forEach(header -> {
                if (incomingHeaders.containsKey(header)) {
                    propagatedHeaders.put((String)header, (String)incomingHeaders.get(header));
                }
            });
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.exiting(CLASS_NAME, "update", propagatedHeaders);
        }
        return propagatedHeaders;
    }
}

