/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client.header;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.eclipse.microprofile.rest.client.ext.ClientHeadersFactory;
import org.eclipse.microprofile.rest.client.ext.DefaultClientHeadersFactoryImpl;
import org.jboss.resteasy.microprofile.client.header.ClientHeaderProvider;
import org.jboss.resteasy.microprofile.client.header.ClientHeaderProviders;
import org.jboss.resteasy.microprofile.client.utils.ClientRequestContextUtils;
import org.jboss.resteasy.microprofile.client.utils.ListCastUtils;

@Priority(value=-2147483648)
public class ClientHeadersRequestFilter
implements ClientRequestFilter {
    private static final MultivaluedMap<String, String> EMPTY_MAP = new MultivaluedHashMap<String, String>();

    @Override
    public void filter(ClientRequestContext requestContext) {
        Method method = ClientRequestContextUtils.getMethod(requestContext);
        MultivaluedHashMap<String, List> headers = new MultivaluedHashMap<String, List>();
        Optional<ClientHeaderProvider> handler = ClientHeaderProviders.getProvider(method);
        handler.ifPresent(h -> h.addHeaders(headers));
        Optional<ClientHeadersFactory> factory = ClientHeaderProviders.getFactory(ClientRequestContextUtils.getDeclaringClass(requestContext));
        requestContext.getHeaders().forEach((key, values) -> headers.put((String)key, ListCastUtils.castToListOfStrings(values)));
        MultivaluedMap<String, String> containerHeaders = (MultivaluedMap<String, String>)requestContext.getProperty("MP_CLIENT_CONTAINER_HEADERS");
        if (containerHeaders == null) {
            containerHeaders = EMPTY_MAP;
        }
        MultivaluedMap<String, String> incomingHeaders = containerHeaders;
        if (!factory.isPresent() || factory.get() instanceof DefaultClientHeadersFactoryImpl) {
            headers.forEach((key, values) -> requestContext.getHeaders().put((String)key, ClientHeadersRequestFilter.castToListOfObjects(values)));
        }
        factory.ifPresent(f -> f.update(incomingHeaders, headers).forEach((key, values) -> requestContext.getHeaders().put((String)key, ClientHeadersRequestFilter.castToListOfObjects(values))));
    }

    private static List<Object> castToListOfObjects(List<String> values) {
        return new ArrayList<Object>(values);
    }
}

