/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.mavendependencyupdater.core.aggregation;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jboss.set.mavendependencyupdater.ArtifactResult;
import org.jboss.set.mavendependencyupdater.ComponentUpgrade;
import org.jboss.set.mavendependencyupdater.LocatedDependency;
import org.jboss.set.mavendependencyupdater.PomDependencyUpdater;
import org.jboss.set.mavendependencyupdater.core.aggregation.ModifiedProperty;

public class ComponentUpgradeAggregator {
    public static List<ArtifactResult<ComponentUpgrade>> aggregateComponentUpgrades(File pomFile, List<ArtifactResult<ComponentUpgrade>> scopedUpgrades) throws IOException, XmlPullParserException {
        URI uri = pomFile.toURI();
        HashSet<ModifiedProperty> modifiedProperties = new HashSet<ModifiedProperty>();
        ArrayList<ArtifactResult<ComponentUpgrade>> aggregatedUpgrades = new ArrayList<ArtifactResult<ComponentUpgrade>>();
        for (ArtifactResult<ComponentUpgrade> scopedUpgrade : scopedUpgrades) {
            Optional<LocatedDependency> locatedDependencyOpt = PomDependencyUpdater.locateDependency(pomFile, scopedUpgrade.getArtifactRef());
            if (!locatedDependencyOpt.isPresent()) continue;
            LocatedDependency locatedDependency = locatedDependencyOpt.get();
            Optional<ComponentUpgrade> upgrade = scopedUpgrade.getAny();
            boolean added = modifiedProperties.add(new ModifiedProperty(uri, locatedDependency.getProfile(), locatedDependency.getVersionProperty(), upgrade.isPresent() ? upgrade.get().getNewVersion() : null));
            if (!added) continue;
            aggregatedUpgrades.add(scopedUpgrade);
        }
        return aggregatedUpgrades;
    }
}

