/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.toolchain.model.io.jdom;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.maven.io.util.AbstractJDOMWriter;
import org.apache.maven.io.util.IndentationCounter;
import org.apache.maven.io.util.WriterUtils;
import org.apache.maven.toolchain.model.PersistedToolchains;
import org.apache.maven.toolchain.model.ToolchainModel;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMFactory;
import org.jdom2.Text;
import org.jdom2.UncheckedJDOMFactory;

public class MavenToolchainsJDOMWriter
extends AbstractJDOMWriter<PersistedToolchains, MavenToolchainsJDOMWriter> {
    private static final String INDENT = "  ";
    private final JDOMFactory factory = new UncheckedJDOMFactory();
    private final String lineSeparator;

    public MavenToolchainsJDOMWriter() {
        this.lineSeparator = "\n";
    }

    protected void insertAtPreferredLocation(Element parent, Element child, IndentationCounter counter) {
        int contentIndex = 0;
        int elementCounter = 0;
        Iterator<Content> it = parent.getContent().iterator();
        Text lastText = null;
        int offset = 0;
        while (it.hasNext() && elementCounter <= counter.getCurrentIndex()) {
            Content next = it.next();
            ++offset;
            if (next instanceof Element) {
                ++elementCounter;
                contentIndex += offset;
                offset = 0;
            }
            if (!(next instanceof Text) || !it.hasNext()) continue;
            lastText = (Text)next;
        }
        if (lastText != null && lastText.getTextTrim().length() == 0) {
            lastText = lastText.clone();
        } else {
            String starter = this.lineSeparator;
            for (int i = 0; i < counter.getDepth(); ++i) {
                starter = starter + INDENT;
            }
            lastText = this.factory.text(starter);
        }
        if (parent.getContentSize() == 0) {
            Text finalText = lastText.clone();
            finalText.setText(finalText.getText().substring(0, finalText.getText().length() - INDENT.length()));
            parent.addContent(contentIndex, finalText);
        }
        parent.addContent(contentIndex, child);
        parent.addContent(contentIndex, lastText);
    }

    protected void iterate2ToolchainModel(IndentationCounter counter, Element parent, Collection list, String childTag) {
        Iterator it = list.iterator();
        Iterator<Element> elIt = parent.getChildren(childTag, parent.getNamespace()).iterator();
        if (!elIt.hasNext()) {
            elIt = null;
        }
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        while (it.hasNext()) {
            Element el;
            ToolchainModel value = (ToolchainModel)it.next();
            if (elIt != null && elIt.hasNext()) {
                el = elIt.next();
                if (!elIt.hasNext()) {
                    elIt = null;
                }
            } else {
                el = this.factory.element(childTag, parent.getNamespace());
                this.insertAtPreferredLocation(parent, el, innerCount);
            }
            this.updateToolchainModel(value, childTag, innerCount, el);
            innerCount.increaseCount();
        }
        if (elIt != null) {
            while (elIt.hasNext()) {
                elIt.next();
                elIt.remove();
            }
        }
    }

    protected void updatePersistedToolchains(PersistedToolchains persistedToolchains, String xmlTag, IndentationCounter counter, Element element) {
        Element root = element;
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        this.iterate2ToolchainModel(innerCount, root, persistedToolchains.getToolchains(), "toolchain");
    }

    protected void updateToolchainModel(ToolchainModel toolchainModel, String xmlTag, IndentationCounter counter, Element element) {
        Element root = element;
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "type", toolchainModel.getType() == null ? null : toolchainModel.getType(), null);
        WriterUtils.findAndReplaceXpp3DOM(innerCount, root, "provides", (Xpp3Dom)toolchainModel.getProvides());
        WriterUtils.findAndReplaceXpp3DOM(innerCount, root, "configuration", (Xpp3Dom)toolchainModel.getConfiguration());
    }

    @Override
    protected void update(PersistedToolchains source, IndentationCounter indentationCounter, Element rootElement) throws IOException {
        this.updatePersistedToolchains(source, "toolchains", indentationCounter, rootElement);
    }
}

